/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import com.shanebeestudios.skbee.api.util.BlockDataUtils;
import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockData - Tag")
@Description(value={"Get/set a block data tag of BlockData or a Block."})
@Examples(value={"set {_water} to block data tag \"waterlogged\" of event-block", "set block data tag \"waterlogged\" of {_blockData} to true", "set block data tag \"waterlogged\" of event-block to true", "set blockdata tag \"waterlogged\" of event-block without updates to true"})
@Since(value={"1.0.0, 2.16.1 (Variable Support)"})
public class ExprBlockDataTag
extends SimpleExpression<Object> {
    private Expression<String> tag;
    private Expression<?> object;
    private boolean applyPhysics;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.tag = exprs[0];
        this.object = exprs[1];
        this.applyPhysics = !parseResult.hasTag("1");
        return true;
    }

    protected Object @Nullable [] get(Event event) {
        String tagString = (String)this.tag.getSingle(event);
        if (tagString == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : this.object.getArray(event)) {
            BlockData blockData;
            if (object instanceof Block) {
                Block block = (Block)object;
                blockData = block.getBlockData();
            } else {
                BlockData bd;
                if (!(object instanceof BlockData)) continue;
                blockData = bd = (BlockData)object;
            }
            Object value = BlockDataUtils.getBlockDataValueFromTag(blockData, tagString);
            if (value == null) continue;
            list.add(value);
        }
        return list.toArray(new Object[0]);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        boolean update = true;
        String tag = (String)this.tag.getSingle(event);
        ArrayList<BlockData> blockDataList = new ArrayList<BlockData>();
        for (Object object : this.object.getArray(event)) {
            if (object instanceof BlockData) {
                BlockData oldBlockData = (BlockData)object;
                BlockData newBlockData = BlockDataUtils.setBlockDataTag(oldBlockData, tag, delta[0]);
                if (newBlockData == null) {
                    this.tagError("Invalid tag \"" + tag + "\" for this blockdata: " + oldBlockData.getAsString());
                    continue;
                }
                blockDataList.add(newBlockData);
                continue;
            }
            if (!(object instanceof Block)) continue;
            Block block = (Block)object;
            update = false;
            BlockData oldBlockData = block.getBlockData();
            BlockData newBlockData = BlockDataUtils.setBlockDataTag(oldBlockData, tag, delta[0]);
            if (newBlockData == null) {
                this.tagError("Invalid tag \"" + tag + "\" for this block: " + oldBlockData.getAsString());
                continue;
            }
            block.setBlockData(newBlockData, this.applyPhysics);
        }
        if (!update) {
            return;
        }
        this.object.change(event, (Object[])blockDataList.toArray(new BlockData[0]), Changer.ChangeMode.SET);
    }

    public boolean isSingle() {
        return this.object.isSingle();
    }

    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String updates = !this.applyPhysics ? " without updates" : "";
        return "block data tag " + this.tag.toString(e, d) + " of " + this.object.toString(e, d) + updates;
    }

    private void tagError(String message) {
        this.warningRegex(message, "tag \\\"\\w+\\\"");
    }

    static {
        Skript.registerExpression(ExprBlockDataTag.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"block[ ](data|state) tag %string% of %blocks/blockdatas% [1:without updates]"});
    }
}

