/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDropItemEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Block Dropped Items")
@Description(value={"Represents the dropped items in a block drop item event.", "`block dropped items` = The dropped item entities.", "`block dropped itemtypes` = The dropped item."})
@Examples(value={"on block drop item:", "\tteleport block dropped items to player"})
@Since(value={"2.6.0"})
public class ExprBlockDrops
extends SimpleExpression<Object> {
    private boolean itemType;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(BlockDropItemEvent.class)) {
            Skript.error((String)"'block dropped items' are only available in a block drop item event.");
            return false;
        }
        this.itemType = matchedPattern == 1;
        return true;
    }

    @Nullable
    protected Object[] get(Event event) {
        BlockDropItemEvent dropEvent = (BlockDropItemEvent)event;
        List items = dropEvent.getItems();
        if (this.itemType) {
            ArrayList itemTypes = new ArrayList();
            items.forEach(item -> itemTypes.add(new ItemType(item.getItemStack())));
            return itemTypes.toArray(new ItemType[0]);
        }
        return items.toArray(new Item[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<?> getReturnType() {
        return this.itemType ? ItemType.class : Item.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "block dropped items";
    }

    static {
        Skript.registerExpression(ExprBlockDrops.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"block dropped (items|item entities)", "block dropped itemtypes"});
    }
}

