/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockState - Get")
@Description(value={"Get a captured state of a block, which will not change automatically.", "Unlike Block, which only one object can exist per coordinate, BlockState can exist multiple times for any given Block.", "This can later be used to update, which will force the block back to this state."})
@Examples(value={"set {_state} to blockstate of event-block", "set event-block to air", "wait 1 minute", "force update {_state} without physics updates"})
@Since(value={"2.13.0"})
public class ExprBlockStateGet
extends SimplePropertyExpression<Block, BlockState> {
    @Nullable
    public BlockState convert(Block block) {
        return block.getState();
    }

    @NotNull
    public Class<? extends BlockState> getReturnType() {
        return BlockState.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "block state";
    }

    static {
        ExprBlockStateGet.register(ExprBlockStateGet.class, BlockState.class, (String)"(captured|block)[ ]state[s]", (String)"blocks");
    }
}

