/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Client Brand")
@Description(value={"Returns player's client brand name. If the client didn't send this information, the brand name will be null.", "For the Notchian client this name defaults to \"vanilla\". Some modified clients report other names such as \"forge\".", "Requires a PaperMC server."})
@Examples(value={"broadcast client brand of player"})
@Since(value={"2.16.0"})
public class ExprClientBrand
extends SimplePropertyExpression<Player, String> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.methodExists(Player.class, (String)"getClientBrandName", (Class[])new Class[0])) {
            Skript.error((String)"'client brand' expression requires a PaperMC server.");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public String convert(Player player) {
        return player.getClientBrandName();
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "client brand";
    }

    static {
        ExprClientBrand.register(ExprClientBrand.class, String.class, (String)"client brand", (String)"players");
    }
}

