/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.EnchantmentType;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Enchantment")
@Description(value={"Get the type of enchantment from an Enchantment Type."})
@Examples(value={"loop enchantments of player's tool:", "\tset {_level} to enchantment level of loop-value", "\tset {_enchant} to enchantment of loop-value"})
@Since(value={"1.16.0"})
public class ExprEnchantment
extends SimplePropertyExpression<EnchantmentType, Enchantment> {
    @Nullable
    public Enchantment convert(EnchantmentType enchantmentType) {
        return enchantmentType.getType();
    }

    @NotNull
    public Class<? extends Enchantment> getReturnType() {
        return Enchantment.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "enchantment";
    }

    static {
        ExprEnchantment.register(ExprEnchantment.class, Enchantment.class, (String)"enchantment", (String)"enchantmenttypes");
    }
}

