/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Player Time")
@Description(value={"Represents the current time on the player's client.", "When relative is used the player's time will be kept synchronized to its world time with the specified offset.", "When using non-relative time the player's time will stay fixed at the specified time parameter.", "It's up to the caller to continue updating the player's time.", "To restore player time to normal use reset.", "Both Time and TimeSpan can be used for this. It is best to use Time for non-relative and TimeSpan for relative.", "Relative will return as a TimeSpan (the offset from world time), non-relative will return as a Time."})
@Examples(value={"set player time of player to 12:00am", "set player time of all players to 6pm", "set relative player time of player to 12000 ticks", "set relative player time of player to 10 minutes", "set relative player time of all players to 6000 ticks", "add 10 minutes to player time of player", "add 1 minute to relative player time of player", "remove 10 minutes from player time of all players", "remove 1 minute from relative player time of player", "reset player time of player", "reset player time of all players"})
@Since(value={"3.3.0"})
public class ExprPlayerTime
extends SimplePropertyExpression<Player, Object> {
    private boolean relative;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.relative = parseResult.hasTag("relative");
        this.setExpr(exprs[0]);
        return true;
    }

    @Nullable
    public Object convert(Player player) {
        if (this.relative) {
            return new Timespan(Timespan.TimePeriod.TICK, player.getPlayerTimeOffset());
        }
        return new Time((int)player.getPlayerTime());
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Time.class, Timespan.class});
        }
        if (mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        block6: {
            block5: {
                if (mode != Changer.ChangeMode.RESET) break block5;
                for (Player player : (Player[])this.getExpr().getArray(event)) {
                    player.resetPlayerTime();
                }
                break block6;
            }
            if (delta == null) break block6;
            int ticks = 0;
            Object object = delta[0];
            if (object instanceof Timespan) {
                Timespan timespan = (Timespan)object;
                ticks = (int)timespan.getAs(Timespan.TimePeriod.TICK);
            } else {
                object = delta[0];
                if (object instanceof Time) {
                    Time time = (Time)object;
                    ticks = time.getTicks();
                }
            }
            for (Player player : (Player[])this.getExpr().getArray(event)) {
                int value = this.getValue(mode, player, ticks);
                player.setPlayerTime((long)value, this.relative);
            }
        }
    }

    private int getValue(Changer.ChangeMode mode, Player player, int ticks) {
        int value = 0;
        if (mode == Changer.ChangeMode.ADD) {
            value = this.relative ? (int)player.getPlayerTimeOffset() + ticks : (int)player.getPlayerTime() + ticks;
        } else if (mode == Changer.ChangeMode.REMOVE) {
            value = this.relative ? (int)player.getPlayerTimeOffset() - ticks : (int)player.getPlayerTime() - ticks;
        } else if (mode == Changer.ChangeMode.SET) {
            value = ticks;
        }
        return value;
    }

    @NotNull
    public Class<?> getReturnType() {
        if (this.relative) {
            return Timespan.class;
        }
        return Time.class;
    }

    @NotNull
    protected String getPropertyName() {
        String relative = this.relative ? "relative " : "";
        return relative + "player time";
    }

    static {
        ExprPlayerTime.register(ExprPlayerTime.class, Object.class, (String)"[:relative] (player|client) time", (String)"players");
    }
}

