/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Shoot Bow - Should Consume")
@Description(value={"Get/set whether or not the consumable item should be consumed in an entity shoot bow event."})
@Examples(value={"on entity shoot bow:", "\tif shot bow is a bow:", "\t\tset should consume item to false"})
@Since(value={"2.16.0"})
public class ExprShootBowShouldConsume
extends SimpleExpression<Boolean> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(EntityShootBowEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in the entity shoot bow event."));
            return false;
        }
        return true;
    }

    @Nullable
    protected Boolean[] get(Event event) {
        if (event instanceof EntityShootBowEvent) {
            EntityShootBowEvent shootBowEvent = (EntityShootBowEvent)event;
            return new Boolean[]{shootBowEvent.shouldConsumeItem()};
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (!(event instanceof EntityShootBowEvent)) {
            return;
        }
        EntityShootBowEvent shootBowEvent = (EntityShootBowEvent)event;
        if (mode != Changer.ChangeMode.SET) {
            return;
        }
        if (delta != null && (object = delta[0]) instanceof Boolean) {
            LivingEntity livingEntity;
            Boolean shouldConsume = (Boolean)object;
            shootBowEvent.setConsumeItem(shouldConsume.booleanValue());
            if (!shouldConsume.booleanValue() && (livingEntity = shootBowEvent.getEntity()) instanceof Player) {
                Player player = (Player)livingEntity;
                player.updateInventory();
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "should consume item";
    }

    static {
        Skript.registerExpression(ExprShootBowShouldConsume.class, Boolean.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"should consume item"});
    }
}

