/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawner - Max Nearby Entities")
@Description(value={"Set the new maximum amount of similar entities that are allowed to be within spawning range of a spawner.", "If more than the maximum number of entities are within range, the spawner will not spawn and try again.", "Default value is 16."})
@Examples(value={"add 10 to maximum nearby entities of {_spawner}", "remove 10 from maximum nearby entities of {_spawner}", "reset maximum nearby entities of {_spawner}", "set maximum nearby entities of {_spawner} to 10"})
@Since(value={"2.16.0"})
public class ExprSpawnerMaxNearbyEntities
extends SimplePropertyExpression<Block, Integer> {
    private static final int DEFAULT_MAX_NEARBY_ENTITIES = 16;

    @Nullable
    public Integer convert(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            return spawner.getMaxNearbyEntities();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Integer.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int changeValue = delta == null ? 16 : (Integer)delta[0];
        switch (mode) {
            case SET: 
            case RESET: {
                for (Block block : (Block[])this.getExpr().getArray(event)) {
                    BlockState blockState = block.getState();
                    if (!(blockState instanceof CreatureSpawner)) continue;
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    spawner.setMaxNearbyEntities(Math.max(changeValue, 0));
                    spawner.update();
                }
                break;
            }
            case REMOVE: {
                changeValue = -changeValue;
            }
            case ADD: {
                for (Block block : (Block[])this.getExpr().getArray(event)) {
                    BlockState blockState = block.getState();
                    if (!(blockState instanceof CreatureSpawner)) continue;
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    int value = spawner.getMaxNearbyEntities() + changeValue;
                    spawner.setMaxNearbyEntities(Math.max(value, 0));
                    spawner.update();
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    protected String getPropertyName() {
        return "max nearby spawner entities";
    }

    static {
        ExprSpawnerMaxNearbyEntities.register(ExprSpawnerMaxNearbyEntities.class, Integer.class, (String)"max nearby [spawner] entities", (String)"blocks");
    }
}

