/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.event.Event;
import org.bukkit.event.server.TabCompleteEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Tab Completions")
@Description(value={"Set the tab completions used in a tab complete event.", "You can specify which position in the command arguments also.", "You can also remove texts from tab completions."})
@Examples(value={"on tab complete of \"/mycommand\":", "\tset tab completions for position 1 to \"one\", \"two\" and \"three\"", "\tset tab completions for position 2 to 1, 2 and 3", "\tset tab completions for position 3 to all players", "\tset tab completions for position 4 to (indexes of {blocks::*})", "", "on tab complete:", "\tif event-string contains \"/ver\":", "\t\tremove \"PermissionsEx\" from tab completions"})
@Since(value={"1.7.0"})
public class ExprTabCompletion
extends SimpleExpression<String> {
    private Expression<Number> position;
    private boolean last;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(TabCompleteEvent.class)) {
            Skript.error((String)"Tab completions are only usable in a tab complete event.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.position = exprs[0];
        this.last = parseResult.hasTag("last");
        return true;
    }

    protected String @NotNull [] get(@NotNull Event event) {
        return ((TabCompleteEvent)event).getCompletions().toArray(new String[0]);
    }

    public Class<?> @Nullable [] acceptChange(@NotNull Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            case Changer.ChangeMode.SET, Changer.ChangeMode.REMOVE, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE_ALL -> (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
            default -> null;
        };
    }

    public void change(@NotNull Event event, @Nullable Object[] objects, @NotNull Changer.ChangeMode mode) {
        if (!(event instanceof TabCompleteEvent)) {
            return;
        }
        TabCompleteEvent tabCompleteEvent = (TabCompleteEvent)event;
        Integer number = this.position != null ? (Number)((Number)this.position.getSingle(event)) : (Number)-1;
        int position = 1;
        if (number != null) {
            position = number;
        }
        String buff = tabCompleteEvent.getBuffer();
        String[] buffers = buff.split(" ");
        if (this.last) {
            position = buffers.length;
        }
        String last = buff.substring(buff.length() - 1);
        if (position == -1 || position == buffers.length && last.equalsIgnoreCase(" ") || position + 1 == buffers.length && !last.equalsIgnoreCase(" ")) {
            switch (mode) {
                case SET: 
                case ADD: {
                    String arg = position == buffers.length || position == -1 ? "" : buffers[position];
                    ArrayList<String> completions = mode == Changer.ChangeMode.SET ? new ArrayList<String>() : new ArrayList(tabCompleteEvent.getCompletions());
                    for (Object o : objects) {
                        String object = Classes.toString((Object)o);
                        if (!StringUtils.contains((String)object, (String)arg, (boolean)false)) continue;
                        completions.add(object);
                    }
                    tabCompleteEvent.setCompletions(completions);
                    break;
                }
                case REMOVE: {
                    for (Object object : objects) {
                        try {
                            assert (object != null);
                            tabCompleteEvent.getCompletions().remove(object.toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    break;
                }
                case DELETE: {
                    tabCompleteEvent.setCompletions(Collections.singletonList(""));
                }
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String pos = this.last ? " for last position" : (this.position != null ? " for position " + this.position.toString(e, d) : "");
        return "tab completions" + pos;
    }

    static {
        Skript.registerExpression(ExprTabCompletion.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[skbee] tab completion[s] [(of|for) (last:last position|position %-number%)]"});
    }
}

