/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="World Time")
@Description(value={"Get/set the time of world, represented as an integer.", "`world time` = The 24000 tick day cycle of a world.", "`full world time` = The time of a world over all days."})
@Examples(value={"set {_time} to world time of world of player", "set {_time} to full world time of world of player", "set time of world of player to 12000", "set full time of world of player to 1000000", "add 1000 to world time of world of player", "add 1000 to full world time of world of player", "remove 100 from world time of world of player", "remove 50 from full world time of world of player"})
@Since(value={"3.11.0"})
public class ExprWorldTime
extends SimplePropertyExpression<World, Long> {
    private boolean full;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.full = parseResult.hasTag("full");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Long convert(World from) {
        if (this.full) {
            return from.getFullTime();
        }
        return from.getTime();
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Long.class});
            default -> null;
        };
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        long l;
        Object object;
        if (delta != null && (object = delta[0]) instanceof Long) {
            Long l2 = (Long)object;
            l = l2;
        } else {
            l = 0L;
        }
        long time = l;
        for (World world : (World[])this.getExpr().getArray(event)) {
            long changeValue;
            long l3 = changeValue = this.full ? world.getFullTime() : world.getTime();
            changeValue = mode == Changer.ChangeMode.ADD ? (changeValue += time) : (mode == Changer.ChangeMode.REMOVE ? (changeValue -= time) : time);
            if (this.full) {
                world.setFullTime(changeValue);
                continue;
            }
            world.setTime(changeValue);
        }
    }

    protected String getPropertyName() {
        return this.full ? "full world time" : "world time";
    }

    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    static {
        ExprWorldTime.register(ExprWorldTime.class, Long.class, (String)"[:full] world time", (String)"worlds");
    }
}

