/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.property.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.property.Property;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converters;

@Name(value="Property - Property of Object")
@Description(value={"Represents different properties of an object.", "See [**Property Wiki**](https://github.com/ShaneBeee/SkBee/wiki/Properties) for available properties and examples."})
@Examples(value={""})
@Since(value={"3.10.0"})
public class ExprProperty<F, T>
extends SimpleExpression<T> {
    private Literal<Property<F, T>> property;
    private Expression<F> objects;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.property = (Literal)exprs[matchedPattern];
        this.objects = LiteralUtils.defendExpression(exprs[matchedPattern == 0 ? 1 : 0]);
        if (this.objects.getReturnType().isAssignableFrom(((Property)this.property.getSingle()).getPropertyHolder())) {
            return true;
        }
        if (((Property)this.property.getSingle()).getPropertyHolder().isAssignableFrom(this.objects.getReturnType())) {
            return true;
        }
        if (Converters.converterExists((Class)this.objects.getReturnType(), ((Property)this.property.getSingle()).getPropertyHolder())) {
            return true;
        }
        ClassInfo propertyInfo = Classes.getExactClassInfo(((Property)this.property.getSingle()).getPropertyHolder());
        ClassInfo found = Classes.getExactClassInfo((Class)this.objects.getReturnType());
        Skript.error((String)("Property '" + ((Property)this.property.getSingle()).getName() + "' can only be used on '" + String.valueOf(propertyInfo) + "' but found '" + String.valueOf(found) + "'"));
        return false;
    }

    protected T @Nullable [] get(Event event) {
        ArrayList<Object> objects = new ArrayList<Object>();
        Property property = (Property)this.property.getSingle();
        if (property == null) {
            return null;
        }
        for (Object from : this.objects.getArray(event)) {
            if (!property.getPropertyHolder().isAssignableFrom(from.getClass()) && (from = Converters.convert((Object)from, property.getPropertyHolder())) != null && !property.getPropertyHolder().isAssignableFrom(from.getClass())) continue;
            Object propertyReturn = property.get(from);
            if (property.isArray()) {
                objects.addAll(Arrays.asList((Object[])propertyReturn));
                continue;
            }
            objects.add(propertyReturn);
        }
        return objects.toArray(new Object[0]);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (this.property == null || this.property.getSingle() == null) {
            return null;
        }
        return ((Property)this.property.getSingle()).acceptChange(mode);
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object change;
        Property property = (Property)this.property.getSingle();
        Object object = change = delta != null ? delta[0] : null;
        if (property == null) {
            return;
        }
        block7: for (Object object2 : this.objects.getArray(event)) {
            if (!property.getPropertyHolder().isAssignableFrom(object2.getClass()) && (object2 = Converters.convert((Object)object2, property.getPropertyHolder())) != null && !property.getPropertyHolder().isAssignableFrom(object2.getClass())) continue;
            switch (mode) {
                case SET: {
                    property.set(object2, property.isArray() ? delta : change);
                    continue block7;
                }
                case ADD: {
                    property.add(object2, property.isArray() ? delta : change);
                    continue block7;
                }
                case REMOVE: {
                    property.remove(object2, property.isArray() ? delta : change);
                    continue block7;
                }
                case DELETE: {
                    property.delete(object2);
                    continue block7;
                }
                case RESET: {
                    property.reset(object2);
                }
            }
        }
    }

    public boolean isSingle() {
        return this.objects.isSingle() && !((Property)this.property.getSingle()).getReturnType().isArray();
    }

    @NotNull
    public Class<? extends T> getReturnType() {
        return ((Property)this.property.getSingle()).getReturnType();
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return this.property.toString(e, d) + " property of " + this.objects.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprProperty.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%*property% property of %objects%", "%objects%'[s] %*property% property"});
    }
}

