/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.event.Event;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.Nullable;

@Name(value="Recipe Choice - Material Choice")
@Description(value={"A material choice is a list of items or a minecraft tag, that can be used as an option in some recipes.", "Will return as a RecipeChoice.", "When using the 'every' item type, this will grab all relatable items in a list, ie: 'every sword'.", "This allows you to have one specific slot of a recipe to accept multiple items, without having to create multiple recipes.", "Do note that material choices do not accept custom items (ie: items with names, lore, enchants, etc). Requires Minecraft 1.13+"})
@Examples(value={"set {_a} to material choice of diamond sword, diamond shovel and diamond hoe", "set {_choice} to material choice of minecraft tag \"minecraft:planks\""})
@Since(value={"1.10.0"})
public class ExprMaterialChoice
extends SimpleExpression<RecipeChoice.MaterialChoice> {
    private Expression<?> objects;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objects = LiteralUtils.defendExpression(exprs[0]);
        return true;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    RecipeChoice.MaterialChoice @Nullable [] get(Event event) {
        ArrayList materials = new ArrayList();
        for (Object object : this.objects.getArray(event)) {
            Tag tag;
            if (object instanceof ItemType) {
                ItemType itemType = (ItemType)object;
                itemType.getAll().forEach(itemStack -> {
                    Material material = itemStack.getType();
                    if (!materials.contains(material) && material.isItem() && !material.isAir()) {
                        materials.add(material);
                    }
                });
                continue;
            }
            if (!(object instanceof Tag) || !Util.isMaterialTag(tag = (Tag)object)) continue;
            RecipeChoice.MaterialChoice materialChoice = new RecipeChoice.MaterialChoice(tag);
            materialChoice.getChoices().forEach(material -> {
                if (!materials.contains(material)) {
                    materials.add(material);
                }
            });
        }
        if (!materials.isEmpty()) {
            return new RecipeChoice.MaterialChoice[]{new RecipeChoice.MaterialChoice(materials)};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends RecipeChoice.MaterialChoice> getReturnType() {
        return RecipeChoice.MaterialChoice.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "material choice of " + this.objects.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprMaterialChoice.class, RecipeChoice.MaterialChoice.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"material choice of %itemtypes/minecrafttags%"});
    }
}

