/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.recipe.RecipeType;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Recipe - Recipe Type")
@Description(value={"Get the type of a recipe.", "\nID = Minecraft or custom NamespacedKey, see examples."})
@Examples(value={"set {_type} to recipe type of recipe with id \"minecraft:oak_door\"", "set {_type} to recipe type of recipe \"skbee:some_recipe\"", "set {_type} to recipe type of recipe with id \"my_recipes:some_custom_recipe\"", "if recipe type of recipe with id \"my_recipes:some_custom_recipe\" = shaped recipe:"})
@Since(value={"2.6.0"})
public class ExprRecipeType
extends SimpleExpression<RecipeType> {
    private Expression<String> key;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.key = exprs[0];
        return true;
    }

    @Nullable
    protected RecipeType[] get(Event event) {
        ArrayList<RecipeType> types = new ArrayList<RecipeType>();
        for (String key : (String[])this.key.getArray(event)) {
            RecipeType recipeType;
            Recipe recipe;
            NamespacedKey namespacedKey = Util.getNamespacedKey(key, false);
            if (namespacedKey == null || (recipe = Bukkit.getRecipe((NamespacedKey)namespacedKey)) == null || (recipeType = RecipeType.getFromRecipe(recipe)) == null) continue;
            types.add(recipeType);
        }
        return types.toArray(new RecipeType[0]);
    }

    public boolean isSingle() {
        return this.key.isSingle();
    }

    @NotNull
    public Class<? extends RecipeType> getReturnType() {
        return RecipeType.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "recipe type of recipe " + this.key.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprRecipeType.class, RecipeType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"recipe type of recipe[s] [with id[s]] %strings%"});
    }
}

