/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.recipe.RecipeUtil;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="Recipe - Register Transmute Recipe")
@Description(value={"Represents a recipe which will change the type of the input material when combined with an additional material, but preserve all custom data. ", "Only the material of the result stack will be used.", "Used for dyeing shulker boxes in Vanilla.", "See [**crafting_transmute**](https://minecraft.wiki/w/Recipe#crafting_transmute) on McWiki for more info.", "Requires Minecraft 1.21.2+", "", "**Entries**:", "- `id` = The ID for your recipe. This is used for recipe discovery and Minecraft's /recipe command.", "- `result` = The material that will be transmuted in the result slot.", "- `input` = The input ingredient (The item which will have it's data copied to the result).", "- `material` = The item to be applied to the first (like a dye).", "- `group` = Define a group to group your recipes together in the recipe book (an example would be having 3 recipes with the same outcome but a variety of ingredients) [optional].", "- `category` = The recipe book category your recipe will be in [optional]. Options are \"building\", \"redstone\", \"equipment\", \"misc\"."})
@Examples(value={"register transmute recipe:", "\tid: \"custom:better_swords\"", "\tresult: netherite sword", "\tinput: minecraft item tag \"minecraft:swords\"", "\tmaterial: netherite ingot"})
@Since(value={"3.8.0"})
public class SecTransmuteRecipe
extends Section {
    private static EntryValidator VALIDATOR;
    private Expression<String> id;
    private Expression<ItemType> result;
    private Expression<RecipeChoice> input;
    private Expression<RecipeChoice> material;
    private Expression<String> group;
    private Expression<String> category;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.id = (Expression)container.getOptional("id", false);
        this.result = (Expression)container.getOptional("result", false);
        this.input = (Expression)container.getOptional("input", false);
        this.material = (Expression)container.getOptional("material", false);
        this.group = (Expression)container.getOptional("group", false);
        this.category = (Expression)container.getOptional("category", false);
        return this.id != null && this.result != null && this.input != null && this.material != null;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        this.execute(event);
        return super.walk(event, false);
    }

    private void execute(Event event) {
        String group;
        String recipeId = (String)this.id.getSingle(event);
        if (recipeId == null) {
            this.error("Missing id");
            return;
        }
        NamespacedKey key = Util.getNamespacedKey(recipeId, false);
        ItemType result = (ItemType)this.result.getSingle(event);
        RecipeChoice input = (RecipeChoice)this.input.getSingle(event);
        RecipeChoice material = (RecipeChoice)this.material.getSingle(event);
        if (key == null) {
            this.error("Invalid id: " + recipeId);
            return;
        }
        if (result == null || !result.getMaterial().isItem() || result.getMaterial().isAir()) {
            this.error("Inavlid result: " + String.valueOf(result));
            return;
        }
        if (input == null) {
            this.error("Invalid input: " + this.input.toString(event, false));
            return;
        }
        if (material == null) {
            this.error("Invalid material: " + this.material.toString(event, false));
            return;
        }
        TransmuteRecipe recipe = new TransmuteRecipe(key, result.getMaterial(), input, material);
        if (this.group != null && (group = (String)this.group.getSingle(event)) != null) {
            recipe.setGroup(group);
        }
        if (this.category != null) {
            String catName_not_pet_dont_worry_fuse_winkey_face = (String)this.category.getSingle(event);
            CraftingBookCategory category = RecipeUtil.getCraftingBookCategory(catName_not_pet_dont_worry_fuse_winkey_face);
            if (category != null) {
                recipe.setCategory(category);
            } else {
                this.error("Invalid category: " + catName_not_pet_dont_worry_fuse_winkey_face);
            }
        }
        Bukkit.removeRecipe((NamespacedKey)key);
        Bukkit.addRecipe((Recipe)recipe);
        RecipeUtil.logTransmuteRecipe(recipe);
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "register transmute recipe";
    }

    static {
        if (Skript.classExists((String)"org.bukkit.inventory.TransmuteRecipe")) {
            SimpleEntryValidator builder = SimpleEntryValidator.builder();
            builder.addRequiredEntry("id", String.class);
            builder.addRequiredEntry("result", ItemType.class);
            builder.addRequiredEntry("input", RecipeChoice.class);
            builder.addRequiredEntry("material", RecipeChoice.class);
            builder.addOptionalEntry("group", String.class);
            builder.addOptionalEntry("category", String.class);
            VALIDATOR = builder.build();
            Skript.registerSection(SecTransmuteRecipe.class, (String[])new String[]{"register transmute recipe"});
        }
    }
}

