/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.scoreboard.NumberFormatUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import io.papermc.paper.scoreboard.numbers.NumberFormat;
import java.util.ArrayList;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Objective;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Objective Number Format")
@Description(value={"Represents the way an objective score can be formatted.", "There are three format types: Blank (nothing there), Fixed (a string of your choosing) and Styled (colored numbers).", "NOTES:", "`set` = You can set the format to any string you'd like (fixed) or a json component (styled number).", "`delete` = Will leave it blank (nothing will be there, just nothing).", "`reset` = Will reset back to its original format.", "See [**Json Formatting**](https://minecraft.wiki/w/Raw_JSON_text_format) on McWiki for more details.", "Requires Paper 1.20.4+"})
@Examples(value={"# Format to a string/text component", "set number format of {-obj} to \"Look Im Fancy!!\"", "set number format of {-obj} for player to \"Im a lil less fancy!\"", "set number format of {-obj} for player to mini message from \"<rainbow>Im a lil more fancy!\"", "", "# Format the number with color/style", "set number format of {-obj} for player to \"{color:red,bold:true}\"", "set number format of {-obj} to \"{color:\"\"##0DEAE3\"\",bold:true}\"", "", "# Format to blank (will apply the 'blank' format)", "delete number format of {-obj}", "delete number format of {-obj} for player", "", "# Reset formatting (will remove all formatting)", "reset number format of {-obj}", "reset number format of {-obj} for player"})
@Since(value={"3.4.0"})
public class ExprObjNumberFormat
extends SimpleExpression<String> {
    private static final boolean HAS_NUMBER_FORMAT = Skript.methodExists(Objective.class, (String)"numberFormat", (Class[])new Class[0]);
    private static final boolean HAS_COMP = SkBee.getPlugin().getAddonLoader().isTextComponentEnabled();
    private static final Class<?>[] CHANGE_TYPES = HAS_COMP ? (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class, String.class}) : (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
    private Expression<Objective> objectives;
    private Expression<?> entries;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!HAS_NUMBER_FORMAT) {
            Skript.error((String)"Number Format requires a Paper 1.20.4+ server.");
            return false;
        }
        this.objectives = exprs[0];
        this.entries = exprs[1];
        return true;
    }

    @Nullable
    protected String[] get(Event event) {
        ArrayList<String> formats = new ArrayList<String>();
        Object[] entries = this.entries != null ? this.entries.getArray(event) : null;
        for (Objective objective : (Objective[])this.objectives.getArray(event)) {
            if (entries == null) {
                NumberFormat numberFormat = objective.numberFormat();
                if (numberFormat == null) continue;
                formats.add(NumberFormatUtils.getStringifiedNumberFormat(numberFormat));
                continue;
            }
            for (Object entry : entries) {
                String stringScore = ExprObjNumberFormat.getStringScore(objective, entry);
                if (stringScore == null) continue;
                formats.add(stringScore);
            }
        }
        return formats.toArray(new String[0]);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return CHANGE_TYPES;
        }
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Object format = null;
        if (delta != null) {
            Object object = delta[0];
            if (object instanceof String) {
                String string = (String)object;
                format = string;
            } else {
                object = delta[0];
                if (object instanceof ComponentWrapper) {
                    ComponentWrapper cw = (ComponentWrapper)object;
                    format = cw;
                }
            }
        } else if (mode == Changer.ChangeMode.DELETE) {
            format = "$blank";
        }
        Object[] entries = this.entries != null ? this.entries.getArray(event) : null;
        for (Objective objective : (Objective[])this.objectives.getArray(event)) {
            if (entries == null) {
                ExprObjNumberFormat.setStringScore(objective, null, format);
                continue;
            }
            for (Object entry : entries) {
                ExprObjNumberFormat.setStringScore(objective, entry, format);
            }
        }
    }

    public boolean isSingle() {
        if (this.entries == null) {
            return this.objectives.isSingle();
        }
        return this.objectives.isSingle() && this.entries.isSingle();
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String entries = this.entries != null ? " for entries " + this.entries.toString(e, d) : "";
        return "number format of " + this.objectives.toString(e, d) + entries;
    }

    @Nullable
    private static String getStringScore(Objective objective, Object entry) {
        NumberFormat numberFormat;
        String stringEntiry = null;
        if (entry instanceof Player) {
            Player player = (Player)entry;
            stringEntiry = player.getName();
        } else if (entry instanceof Entity) {
            Entity entity = (Entity)entry;
            stringEntiry = entity.getUniqueId().toString();
        } else if (entry instanceof String) {
            String string;
            stringEntiry = string = (String)entry;
        }
        if (stringEntiry != null && (numberFormat = objective.getScore(stringEntiry).numberFormat()) != null) {
            return NumberFormatUtils.getStringifiedNumberFormat(numberFormat);
        }
        return null;
    }

    private static void setStringScore(Objective objective, @Nullable Object entry, @Nullable Object score) {
        String stringScore;
        String stringEntiry = null;
        if (entry instanceof Player) {
            Player player = (Player)entry;
            stringEntiry = player.getName();
        } else if (entry instanceof Entity) {
            Entity entity = (Entity)entry;
            stringEntiry = entity.getUniqueId().toString();
        } else if (entry instanceof String) {
            String string;
            stringEntiry = string = (String)entry;
        }
        NumberFormat numberFormat = null;
        if (score instanceof String && (stringScore = (String)score).equalsIgnoreCase("$blank")) {
            numberFormat = NumberFormatUtils.getNumberFormatBlank();
        } else if (score instanceof String) {
            Object stringScore2 = (String)score;
            if (((String)stringScore2).startsWith("{") && ((String)stringScore2).endsWith("}")) {
                stringScore2 = ((String)stringScore2).replace("}", "") + ",\"text\":\"\"}";
                numberFormat = NumberFormatUtils.getJsonFormat((String)stringScore2);
            } else {
                numberFormat = NumberFormatUtils.getNumberFormatFixed((String)stringScore2);
            }
        } else if (HAS_COMP && score instanceof ComponentWrapper) {
            ComponentWrapper cw = (ComponentWrapper)score;
            numberFormat = NumberFormatUtils.getNumberFormatFixed(cw);
        }
        if (stringEntiry != null) {
            objective.getScore(stringEntiry).numberFormat(numberFormat);
        } else {
            objective.numberFormat(numberFormat);
        }
    }

    static {
        Skript.registerExpression(ExprObjNumberFormat.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"number format of %objective% [for %-entities/strings%]"});
    }
}

