/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.scoreboard.ScoreboardUtils;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Scoreboard Get")
@Description(value={"Get the vanilla scoreboard, or create a new scoreboard (custom scoreboard are not persistent)."})
@Examples(value={"set {_scoreboard} to scoreboard of player", "set scoreboard of player to a new scoreboard", "set scoreboard of player to the vanilla scoreboard", "reset scoreboard of player"})
@Since(value={"3.9.0"})
public class ExprScoreboard
extends SimpleExpression<Scoreboard> {
    private int pattern;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        return true;
    }

    protected Scoreboard @Nullable [] get(Event event) {
        return new Scoreboard[]{this.pattern == 1 ? ScoreboardUtils.getMainScoreboard() : ScoreboardUtils.getNewScoreboard()};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Scoreboard> getReturnType() {
        return Scoreboard.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return this.pattern == 1 ? "vanilla scoreboard" : "new scoreboard";
    }

    static {
        Skript.registerExpression(ExprScoreboard.class, Scoreboard.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] (new|custom) scoreboard", "[the] (vanilla|main|server|default) scoreboard"});
    }
}

