/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.structure.StructureManager;
import com.shanebeestudios.skbee.api.structure.StructureWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - Save/Delete")
@Description(value={"Save a structure to file (will overwrite if file already exists), or delete a structure file. Requires MC 1.17.1+"})
@Examples(value={"save structure {_s}", "save structures {_s::*}", "delete structure {_s}"})
@Since(value={"1.12.0"})
public class EffStructureSave
extends Effect {
    private static final StructureManager STRUCTURE_MANAGER = SkBee.getPlugin().getStructureManager();
    private Expression<StructureWrapper> structures;
    private boolean save;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.structures = exprs[0];
        this.save = parseResult.mark == 0;
        return true;
    }

    protected void execute(Event event) {
        for (StructureWrapper structureWrapper : (StructureWrapper[])this.structures.getArray(event)) {
            if (this.save) {
                structureWrapper.save();
                continue;
            }
            STRUCTURE_MANAGER.deleteStructure(structureWrapper);
        }
    }

    public String toString(@Nullable Event e, boolean d) {
        return String.format("%s structure[s] %s", this.save ? "save" : "delete", this.structures.toString(e, d));
    }

    static {
        Skript.registerEffect(EffStructureSave.class, (String[])new String[]{"(save|1:delete) structure[s] %structures%"});
    }
}

