/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.type;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.structure.StructureManager;
import com.shanebeestudios.skbee.api.structure.StructureWrapper;
import com.shanebeestudios.skbee.api.wrapper.EnumWrapper;
import java.util.ArrayList;
import java.util.Comparator;
import org.bukkit.Bukkit;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.jetbrains.annotations.Nullable;

public class Types {
    private static final StructureManager STRUCTURE_MANAGER = SkBee.getPlugin().getStructureManager();

    static {
        Classes.registerClass((ClassInfo)new ClassInfo(StructureWrapper.class, "structure").user(new String[]{"structures?"}).name("Structure").description(new String[]{"Represents a structure that can be saved or pasted into a world.", "In Minecraft these are actually called [**Structure Templates**](https://minecraft.wiki/w/Structure_file).", "These can also be placed using the `/place template` command.", "Use the 'Structure-Object' expression to get a new/existing structure object.", "When using `all structures`, this will only show structures that have been currently loaded into the game."}).since("1.12.0").supplier(() -> {
            ArrayList structures = new ArrayList();
            Bukkit.getStructureManager().getStructures().forEach((namespacedKey, structure) -> structures.add(StructureWrapper.wrap(structure, namespacedKey)));
            return structures.stream().sorted(Comparator.comparing(sw -> sw.getKey().toString())).iterator();
        }).parser((Parser)new Parser<StructureWrapper>(){

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(StructureWrapper structure, int flags) {
                return "structure '" + String.valueOf(structure.getKey()) + "'";
            }

            public String toVariableNameString(StructureWrapper structure) {
                return this.toString(structure, 0);
            }
        }).changer((Changer)new Changer<StructureWrapper>(){

            public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE) {
                    return (Class[])CollectionUtils.array((Object[])new Class[0]);
                }
                return null;
            }

            public void change(StructureWrapper[] what, Object @Nullable [] delta, Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE) {
                    for (StructureWrapper structureWrapper : what) {
                        STRUCTURE_MANAGER.deleteStructure(structureWrapper);
                    }
                }
            }
        }));
        if (Classes.getExactClassInfo(Mirror.class) == null) {
            EnumWrapper<Mirror> MIRROR_ENUM = new EnumWrapper<Mirror>(Mirror.class);
            Classes.registerClass((ClassInfo)MIRROR_ENUM.getClassInfo("mirror").user(new String[]{"mirrors?"}).name("Structure - Mirror").description(new String[]{"Represents the different states of mirroring for a structure. Requires MC 1.17.1+"}).examples(new String[]{"set structure mirror of structure {_s} to front back"}).since("1.12.0"));
        }
        if (Classes.getExactClassInfo(StructureRotation.class) == null) {
            EnumWrapper<StructureRotation> ROTATION_ENUM = new EnumWrapper<StructureRotation>(StructureRotation.class);
            Classes.registerClass((ClassInfo)ROTATION_ENUM.getClassInfo("structurerotation").user(new String[]{"structure ?rotations?"}).name("Structure - Rotation").description(new String[]{"Represents the different states of rotation for a structure. Requires MC 1.17.1+"}).examples(new String[]{"set structure rotation of structure {_s} to clockwise 90"}).since("1.12.0"));
        }
    }
}

