/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Book Pages")
@Description(value={"Allows you to set pages in a book to text components. You can also retrieve the pages. Based on testing, a book's author/title needs to be set AFTER setting the pages, why? I have no idea!"})
@Examples(value={"set {_i} to a written book", "set {_a} to text component of \"RULES\"", "set hover event of {_a} to hover event showing \"make sure to read our rules\"", "set click event of {_a} to click event to run command \"/rules\"", "set page 1 of book {_i} to {_a}", "set book author of {_i} to \"Bob\"", "set book title of {_i} to \"MyBook\"", "give player 1 of {_i}"})
@Since(value={"1.8.0"})
public class ExprBookPages
extends SimpleExpression<ComponentWrapper> {
    private Expression<ItemType> item;
    private Expression<Number> page;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.item = exprs[1];
        this.page = exprs[0];
        return true;
    }

    protected ComponentWrapper @Nullable [] get(@NotNull Event event) {
        ItemType item = (ItemType)this.item.getSingle(event);
        if (item == null) {
            return null;
        }
        if (item.getMaterial() == Material.WRITTEN_BOOK) {
            int page;
            BookMeta bookMeta = (BookMeta)item.getItemMeta();
            Number num = (Number)this.page.getSingle(event);
            int n = page = num == null ? 0 : num.intValue();
            if (bookMeta.getPageCount() >= page) {
                return new ComponentWrapper[]{ComponentWrapper.fromComponent(bookMeta.page(page))};
            }
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper[].class});
        }
        return null;
    }

    public void change(@NotNull Event e, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        ComponentWrapper[] componentWrappers = delta == null ? null : (ComponentWrapper[])delta;
        ItemType book = (ItemType)this.item.getSingle(e);
        if (book == null) {
            return;
        }
        Material bookMaterial = book.getMaterial();
        ComponentWrapper comp = ComponentWrapper.fromComponents(componentWrappers);
        if (book.getMaterial() == Material.WRITTEN_BOOK) {
            BookMeta bookMeta = (BookMeta)book.getItemMeta();
            Number pageNumber = (Number)this.page.getSingle(e);
            int page = pageNumber != null ? pageNumber.intValue() : 0;
            int pageCount = bookMeta.getPageCount();
            if (pageCount < page) {
                for (int i = 0; i < page - pageCount; ++i) {
                    bookMeta.addPage(new String[]{" "});
                }
            }
            bookMeta.page(page, comp.getComponent());
            book.setItemMeta((ItemMeta)bookMeta);
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "page " + this.page.toString(e, d) + " of book " + this.item.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBookPages.class, ComponentWrapper.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"page %number% of [book] %itemtype%"});
    }
}

