/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.nbt.NBTCompound;
import com.shanebeestudios.skbee.api.util.legacy.DialogUtil;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Click Event")
@Description(value={"Create a new click event to add to a text component.", "Supports run command, suggest command, open link, copy to clipboard, change book page, open dialog and custom payload.", "Open dialog and custom payload require Minecraft 1.21.6+"})
@Examples(value={"set {_t} to text component from \"Check out my cool website\"", "add hover event showing \"Clicky clicky to go to spawn!\" to {_t}", "add click event to open url \"https://my.cool.website\" to {_t}", "send component {_t} to player", "", "add click event to show dialog with key \"some:dialog\" to {_t}", "add click event to run custom payload with key \"some:key\" with custom data {_nbt} to {_t}"})
@Since(value={"1.5.0"})
public class ExprClickEvent
extends SimpleExpression<ClickEvent> {
    private static final boolean SUPPORTS_CLIPBOARD;
    private static final boolean SUPPORTS_CUSTOM_PAYLOAD;
    private int pattern;
    private Expression<Object> object;
    private Expression<NBTCompound> nbtData;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern == 3 && !SUPPORTS_CLIPBOARD) {
            Skript.error((String)"'click event to copy %string% to clipboard' is not supported on your server version", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.object = exprs[0];
        if (this.pattern > 4 && !SUPPORTS_CUSTOM_PAYLOAD) {
            Skript.error((String)("'" + parseResult.expr + "' is not supported on your server version"), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (this.pattern == 6) {
            this.nbtData = exprs[1];
        }
        return true;
    }

    protected ClickEvent @Nullable [] get(Event event) {
        ClickEvent.Action action;
        if (this.object == null) {
            return null;
        }
        Object value = this.object.getSingle(event);
        if (value == null) {
            return null;
        }
        if (SUPPORTS_CUSTOM_PAYLOAD) {
            ClickEvent clickEvent = switch (this.pattern) {
                case 1 -> ClickEvent.suggestCommand((String)((String)value));
                case 2 -> ClickEvent.openUrl((String)((String)value));
                case 3 -> ClickEvent.copyToClipboard((String)((String)value));
                case 4 -> ClickEvent.changePage((int)((Number)value).intValue());
                case 5 -> {
                    NamespacedKey namespacedKey;
                    Key key;
                    String string;
                    if (value instanceof String) {
                        string = (String)value;
                        key = Key.key((String)string);
                    } else if (value instanceof NamespacedKey) {
                        namespacedKey = (NamespacedKey)value;
                        key = namespacedKey.key();
                    } else {
                        yield null;
                    }
                    Registry dialogRegistry = RegistryAccess.registryAccess().getRegistry(RegistryKey.DIALOG);
                    if (dialogRegistry == null) {
                        yield null;
                    }
                    Dialog dialog = (Dialog)dialogRegistry.get(key);
                    if (dialog == null) {
                        yield null;
                    }
                    yield DialogUtil.showDialog(dialog);
                }
                case 6 -> {
                    NamespacedKey namespacedKey;
                    Key key;
                    String string;
                    if (value instanceof String) {
                        string = (String)value;
                        key = Key.key((String)string);
                    } else if (value instanceof NamespacedKey) {
                        namespacedKey = (NamespacedKey)value;
                        key = namespacedKey.key();
                    } else {
                        yield null;
                    }
                    NBTCompound nbtData = (NBTCompound)this.nbtData.getSingle(event);
                    if (nbtData == null) {
                        yield null;
                    }
                    BinaryTagHolder nbt = BinaryTagHolder.binaryTagHolder((String)nbtData.toString());
                    yield ClickEvent.custom((Key)key, (BinaryTagHolder)nbt);
                }
                default -> ClickEvent.runCommand((String)((String)value));
            };
            return new ClickEvent[]{clickEvent};
        }
        switch (this.pattern) {
            case 1: {
                action = ClickEvent.Action.SUGGEST_COMMAND;
                break;
            }
            case 2: {
                action = ClickEvent.Action.OPEN_URL;
                break;
            }
            case 3: {
                action = ClickEvent.Action.COPY_TO_CLIPBOARD;
                break;
            }
            case 4: {
                action = ClickEvent.Action.CHANGE_PAGE;
                value = "" + ((Number)Objects.requireNonNull(this.object.getSingle(event))).intValue();
                break;
            }
            default: {
                action = ClickEvent.Action.RUN_COMMAND;
            }
        }
        if (value == null) {
            return null;
        }
        return new ClickEvent[]{ClickEvent.clickEvent((ClickEvent.Action)action, (String)((String)value))};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ClickEvent> getReturnType() {
        return ClickEvent.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        if (this.pattern == 6) {
            String key = this.object.toString(e, d);
            String data = this.nbtData.toString(e, d);
            return "click event to run custom payload with key " + key + " and with data " + data;
        }
        String[] actions = new String[]{"run command", "suggest command", "open url", "copy to clipboard", "change to page", "open dialog"};
        return "click event to " + actions[this.pattern] + " " + this.object.toString(e, d);
    }

    static {
        SUPPORTS_CUSTOM_PAYLOAD = Skript.methodExists(ClickEvent.class, (String)"custom", (Class[])new Class[]{Key.class, String.class});
        SUPPORTS_CLIPBOARD = Skript.fieldExists(ClickEvent.Action.class, (String)"COPY_TO_CLIPBOARD");
        Skript.registerExpression(ExprClickEvent.class, ClickEvent.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] click event to run command %string%", "[a] [new] click event to suggest command %string%", "[a] [new] click event to open (link|url) %string%", "[a] [new] click event to copy %string% to clipboard", "[a] [new] click event to change to page %number%", "[a] [new] click event to (open|show) dialog [with key] %string/namespacedkey%", "[a] [new] click event to run custom payload with key %string/namespacedkey% [and] with [custom] data %nbtcompound%"});
    }
}

