/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Click Event Of")
@Description(value={"Set the click event of a text component."})
@Examples(value={"set {_t} to text component from \"Check out this cool thing at SPAWN!\"", "set hover event of {_t} to a new hover event showing \"Clicky clicky to go to spawn!\"", "set click event of {_t} to a new click event to run command \"/spawn\"", "send component {_t} to player"})
@Since(value={"1.5.0"})
public class ExprClickEventOf
extends PropertyExpression<ComponentWrapper, ClickEvent> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected ClickEvent @NotNull [] get(Event e, ComponentWrapper[] source) {
        return (ClickEvent[])this.get(source, ComponentWrapper::getClickEvent);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ClickEvent.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ClickEvent clickEvent;
        ClickEvent clickEvent2 = clickEvent = delta != null ? (ClickEvent)delta[0] : null;
        if (clickEvent == null) {
            return;
        }
        for (ComponentWrapper component : (ComponentWrapper[])this.getExpr().getArray(e)) {
            component.setClickEvent(clickEvent);
        }
    }

    @NotNull
    public Class<? extends ClickEvent> getReturnType() {
        return ClickEvent.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "click event of " + this.getExpr().toString(e, d);
    }

    static {
        ExprClickEventOf.register(ExprClickEventOf.class, ClickEvent.class, (String)"click event", (String)"textcomponents");
    }
}

