/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.shanebeestudios.skbee.api.skript.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Effective Name")
@Description(value={"Gets the effective name of an item stack shown to the player.", "It takes into account the display name (with italics) from the item meta, the potion effect, translatable name, rarity etc.", "Requires PaperMC 1.21.4+"})
@Examples(value={"broadcast effective name of player's tool"})
@Since(value={"3.13.0"})
public class ExprEffectiveName
extends SimplePropertyExpression<ItemStack, ComponentWrapper> {
    private static final boolean HAS_EFFECTIVE_NAME = Skript.methodExists(ItemStack.class, (String)"effectiveName", (Class[])new Class[0]);

    @Nullable
    public ComponentWrapper convert(ItemStack from) {
        return ComponentWrapper.fromComponent(from.effectiveName());
    }

    protected String getPropertyName() {
        return "effective name";
    }

    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    static {
        if (HAS_EFFECTIVE_NAME) {
            ExprEffectiveName.registerDefault(ExprEffectiveName.class, ComponentWrapper.class, (String)"[component] effective name", (String)"itemstacks");
        }
    }
}

