/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Entity Name")
@Description(value={"Get/set the component name of an entity.", "- `name` = The vanilla name of an Entity, or the player's profile name (cannot be changed).", "- `custom name` = The custom name of an entity, will only show when the player's crosshair is pointed at them.", "- `display name` = Same as custom name, but will always show."})
@Examples(value={"set component entity name of target entity to translate component from \"entity.minecraft.llama\""})
@Since(value={"2.4.0"})
public class ExprNameEntity
extends SimplePropertyExpression<Entity, ComponentWrapper> {
    private boolean custom;
    private boolean display;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.custom = parseResult.hasTag("custom");
        this.display = parseResult.hasTag("display");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public ComponentWrapper convert(Entity entity) {
        if (!(entity instanceof Player)) ** GOTO lbl-1000
        player = (Player)entity;
        if (this.display || this.custom) {
            component = player.displayName();
        } else lbl-1000:
        // 2 sources

        {
            component = this.custom != false || this.display != false ? entity.customName() : entity.name();
        }
        if (component == null) {
            return null;
        }
        return ComponentWrapper.fromComponent(component);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            if (!this.custom && !this.display) {
                Skript.error((String)"'name' cannot be set, rather use custom/display name.");
                return null;
            }
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (mode == Changer.ChangeMode.SET && (entityArray = delta[0]) instanceof ComponentWrapper) {
            ComponentWrapper component = (ComponentWrapper)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                component.setEntityName(entity, this.display);
            }
        }
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    protected String getPropertyName() {
        String name = this.display ? "display name" : (this.custom ? "custom name" : "name");
        return "component entity " + name;
    }

    static {
        ExprNameEntity.register(ExprNameEntity.class, ComponentWrapper.class, (String)"component entity [:custom|:display] name", (String)"entities");
    }
}

