/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.tickmanager.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.ServerTickManager;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Server Tick - Is Sprinting/Stepping")
@Description(value={"Checks if the server is currently sprinting/stepping.", "See [**Tick Command**](https://minecraft.wiki/w/Commands/tick) on McWiki for more details.", "Requires Minecraft 1.20.4+"})
@Examples(value={"if server is sprinting:", "\tkill all players"})
@Since(value={"3.1.0"})
public class CondServerTickSprintStep
extends Condition {
    private boolean sprint;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sprint = parseResult.hasTag("sprinting");
        this.setNegated(parseResult.hasTag("neg"));
        return true;
    }

    public boolean check(Event event) {
        ServerTickManager tickManager = Bukkit.getServerTickManager();
        return !this.isNegated() == (this.sprint ? tickManager.isSprinting() : tickManager.isStepping());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String is = this.isNegated() ? "is not " : "is ";
        return "server " + is + (this.sprint ? "sprinting" : "stepping");
    }

    static {
        Skript.registerCondition(CondServerTickSprintStep.class, (String[])new String[]{"(server|game) (is|neg:(isn't|is not)) [currently] (:sprinting|stepping)"});
    }
}

