/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.villager.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Merchant - Open")
@Description(value={"Open a merchant/villager to a player."})
@Examples(value={"set {_m} to new merchant named \"Le Merchant\"", "open merchant {_m} to player"})
@Since(value={"1.17.0"})
public class EffOpenMerchant
extends Effect {
    private Expression<Object> merchant;
    private Expression<Player> player;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.merchant = exprs[0];
        this.player = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        Object object = this.merchant.getSingle(event);
        Player player = (Player)this.player.getSingle(event);
        if (player == null) {
            return;
        }
        if (object instanceof Villager) {
            Villager villager = (Villager)object;
            player.openMerchant(villager, false);
        } else if (object instanceof Merchant) {
            Merchant merchant = (Merchant)object;
            player.openMerchant(merchant, false);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "open merchant " + this.merchant.toString(e, d) + " to " + this.player.toString(e, d);
    }

    static {
        Skript.registerEffect(EffOpenMerchant.class, (String[])new String[]{"open merchant %merchant/entity% to %player%"});
    }
}

