/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.villager.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Villager - Effects")
@Description(value={"A few effects to make villagers do things."})
@Examples(value={"zombify last spawned villager", "wake up all villagers", "make target entity shake his head", "make target entity sleep at location(100, 64, 100, world \"world\")"})
@Since(value={"1.17.0"})
public class EffVillagerEffects
extends Effect {
    private static final boolean CAN_ZOMBIFY = Skript.methodExists(Villager.class, (String)"zombify", (Class[])new Class[0]);
    private static final boolean CAN_WAKEUP = Skript.methodExists(Villager.class, (String)"wakeup", (Class[])new Class[0]);
    private Expression<LivingEntity> entities;
    private Expression<Location> location;
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern == 0 && !CAN_ZOMBIFY) {
            Skript.error((String)"'zombify %villager%' is not available on your server version.");
            return false;
        }
        if (this.pattern == 1 && !CAN_WAKEUP) {
            Skript.error((String)"'wakeup %villager%' is not available on your server version.");
            return false;
        }
        this.entities = exprs[0];
        this.location = matchedPattern == 3 ? exprs[1] : null;
        return true;
    }

    protected void execute(Event event) {
        Location location = this.location != null ? (Location)this.location.getSingle(event) : null;
        block6: for (LivingEntity entity : (LivingEntity[])this.entities.getArray(event)) {
            if (!(entity instanceof Villager)) continue;
            Villager villager = (Villager)entity;
            switch (this.pattern) {
                case 0: {
                    villager.zombify();
                    continue block6;
                }
                case 1: {
                    if (!villager.isSleeping()) continue block6;
                    villager.wakeup();
                    continue block6;
                }
                case 2: {
                    villager.shakeHead();
                    continue block6;
                }
                case 3: {
                    this.sleepVillager(villager, location);
                }
            }
        }
    }

    private void sleepVillager(Villager villager, Location location) {
        if (location != null) {
            if (villager.getLocation().getWorld() != location.getWorld()) {
                villager.teleport(location);
            }
            villager.sleep(location);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String entity = this.entities.toString(e, d);
        return switch (this.pattern) {
            case 0 -> "zombify " + entity;
            case 1 -> "wakeup " + entity;
            case 2 -> "shake head of " + entity;
            case 3 -> "make " + entity + " sleep at " + this.location.toString(e, d);
            default -> "null";
        };
    }

    static {
        Skript.registerEffect(EffVillagerEffects.class, (String[])new String[]{"zombify %livingentities%", "wake[ ]up %livingentities%", "make %livingentities% shake [(his|their)] head[s]", "make %livingentities% sleep at %location%"});
    }
}

