/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.virtualfurnace.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Machine;
import com.shanebeestudios.skbee.elements.virtualfurnace.type.Types;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="VirtualFurnace - All Machines")
@Description(value={"Get all registered machines."})
@Examples(value={"set {_machines::*} to all virtual furnaces"})
@Since(value={"3.3.0"})
public class ExprVirtualFurnaceAllFurnaces
extends SimpleExpression<Machine> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Nullable
    protected Machine[] get(Event event) {
        ArrayList<Machine> machines = new ArrayList<Machine>(Types.FURNACE_MANAGER.getAllMachines());
        return machines.toArray(new Machine[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends Machine> getReturnType() {
        return Machine.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "all virtual machines";
    }

    static {
        Skript.registerExpression(ExprVirtualFurnaceAllFurnaces.class, Machine.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"all virtual (machines|furnaces)"});
    }
}

