/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.virtualfurnace.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Machine;
import com.shanebeestudios.skbee.elements.virtualfurnace.type.Types;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="VirtualFurnace - Machine from ID")
@Description(value={"Get a virtual furnace from a uuid."})
@Examples(value={"set {_furnace} to virtual furnace from id {_uuid}"})
@Since(value={"3.3.0"})
public class ExprVirtualFurnaceMachineFromID
extends SimpleExpression<Machine> {
    private Expression<String> ids;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.ids = exprs[0];
        return true;
    }

    @Nullable
    protected Machine[] get(Event event) {
        ArrayList<Machine> machines = new ArrayList<Machine>();
        for (String s : (String[])this.ids.getArray(event)) {
            UUID uuid = null;
            try {
                uuid = UUID.fromString(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (uuid == null) continue;
            Machine machine = Types.FURNACE_MANAGER.getByID(uuid);
            machines.add(machine);
        }
        return machines.toArray(new Machine[0]);
    }

    public boolean isSingle() {
        return this.ids.isSingle();
    }

    @NotNull
    public Class<? extends Machine> getReturnType() {
        return Machine.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "virtual machine[s] from id[s] " + this.ids.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprVirtualFurnaceMachineFromID.class, Machine.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[virtual] (machine|furnace)[s] (from|with) (id|uuid)[s] %strings%"});
    }
}

