/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.virtualfurnace.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.FurnaceProperties;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.Properties;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="VirtualFurnace - Furnace Properties Create")
@Description(value={"Create furnace properties to be used in a virtual furnace."})
@Examples(value={"set {_prop} to furnace properties with cook speed multiplier 1.5 and fuel speed multiplier 0.5"})
@Since(value={"3.3.0"})
public class ExprVirtualFurnacePropertiesCreate
extends SimpleExpression<Properties> {
    private Expression<Number> cookX;
    private Expression<Number> fuelX;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.cookX = exprs[0];
        this.fuelX = exprs[1];
        return true;
    }

    @Nullable
    protected Properties[] get(Event event) {
        Number cookNum = (Number)this.cookX.getSingle(event);
        Number fuelNum = (Number)this.fuelX.getSingle(event);
        double cookX = cookNum != null ? cookNum.doubleValue() : 1.0;
        double fuelX = fuelNum != null ? fuelNum.doubleValue() : 1.0;
        String id = "key_machine_" + cookX + "_" + fuelX;
        FurnaceProperties properties = new FurnaceProperties(id).cookMultiplier(cookX).fuelMultiplier(fuelX);
        return new Properties[]{properties};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Properties> getReturnType() {
        return Properties.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String cook = this.cookX.toString(e, d);
        String fuel = this.fuelX.toString(e, d);
        return "furnace properties with cook speed " + cook + " and fuel speed " + fuel;
    }

    static {
        Skript.registerExpression(ExprVirtualFurnacePropertiesCreate.class, Properties.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[virtual] furnace properties with cook speed multiplier %number% and [with] fuel speed multiplier %number%"});
    }
}

