/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldborder.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="WorldBorder - Center")
@Description(value={"Get/set the center location of a world border."})
@Examples(value={"set border center of world border of player to location(1,1,1)"})
@Since(value={"1.17.0"})
public class ExprWorldBorderCenter
extends SimplePropertyExpression<WorldBorder, Location> {
    @Nullable
    public Location convert(WorldBorder worldBorder) {
        return worldBorder.getCenter();
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Location.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Location location = (Location)delta[0];
        if (location == null) {
            return;
        }
        for (WorldBorder border : (WorldBorder[])this.getExpr().getArray(event)) {
            border.setCenter(location);
        }
    }

    @NotNull
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "world border center";
    }

    static {
        ExprWorldBorderCenter.register(ExprWorldBorderCenter.class, Location.class, (String)"[world] border center", (String)"worldborders");
    }
}

