/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesMap;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldConfig;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldCreator;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Load/Unload/Delete World")
@Description(value={"Load a world from a world creator.", "Worlds created/loaded with a world creator, are saved in the 'plugins/SkBee/worlds.yml' file", "and automatically loaded on server start if auto-load is enabled in the config.", "If you wish to import a world, just use a world creator with a name that matches that world folder.", "You can load a world from a name (assuming this world is in your world directory and not loaded).", "You can unload a world with an option to save/not save (defaults to saving).", "You can also delete a world, but only a custom world."})
@Examples(value={"set {_w} to a new world creator named \"my-world\"", "load world from world creator {_w}", "", "load world \"my-world\"", "unload world world(\"my-world\")"})
@Since(value={"1.8.0"})
public class EffLoadWorld
extends Effect {
    private static final BeeWorldConfig BEE_WORLD_CONFIG = SkBee.getPlugin().getBeeWorldConfig();
    private int pattern;
    private Expression<BeeWorldCreator> creator;
    private Expression<String> worldName;
    private Expression<World> world;
    private boolean save;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.creator = this.pattern == 0 ? exprs[0] : null;
        this.worldName = this.pattern == 1 || this.pattern == 3 ? exprs[0] : null;
        this.world = this.pattern == 2 ? exprs[0] : null;
        this.save = this.pattern == 2 && parseResult.mark != 1;
        return true;
    }

    protected void execute(Event event) {
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        TriggerItem next = this.getNext();
        if (this.pattern == 0) {
            BeeWorldCreator worldCreator = (BeeWorldCreator)this.creator.getSingle(event);
            if (worldCreator != null) {
                VariablesMap localVars = Variables.removeLocals((Event)event);
                ((CompletableFuture)worldCreator.loadWorld().thenAccept(world1 -> {
                    if (localVars != null) {
                        Variables.setLocalVariables((Event)event, (Object)localVars);
                    }
                    if (next != null) {
                        TriggerItem.walk((TriggerItem)next, (Event)event);
                    }
                    Variables.removeLocals((Event)event);
                })).exceptionally(t -> {
                    if (next != null) {
                        TriggerItem.walk((TriggerItem)next, (Event)event);
                    }
                    throw Skript.exception((Throwable)t, (String[])new String[0]);
                });
                return null;
            }
        } else if (this.pattern == 1) {
            World world;
            String worldName;
            if (this.worldName != null && (worldName = (String)this.worldName.getSingle(event)) != null && (world = Bukkit.getWorld((String)worldName)) == null) {
                new WorldCreator(worldName).createWorld();
            }
        } else if (this.pattern == 2) {
            if (this.world == null) {
                return next;
            }
            World world = (World)this.world.getSingle(event);
            if (world == null) {
                return next;
            }
            this.unloadWorld(world);
        } else if (this.pattern == 3) {
            if (this.worldName == null) {
                return next;
            }
            String worldName = (String)this.worldName.getSingle(event);
            if (worldName == null) {
                return next;
            }
            World world = Bukkit.getWorld((String)worldName);
            if (world != null && !this.unloadWorld(world)) {
                return next;
            }
            BEE_WORLD_CONFIG.deleteWorld((String)this.worldName.getSingle(event));
        }
        return next;
    }

    private boolean unloadWorld(@NotNull World world) {
        World mainWorld = (World)Bukkit.getWorlds().getFirst();
        if (world == mainWorld) {
            return false;
        }
        world.getPlayers().forEach(player -> player.teleport(mainWorld.getSpawnLocation()));
        return Bukkit.unloadWorld((World)world, (boolean)this.save);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        switch (this.pattern) {
            case 1: {
                return String.format("load world %s", this.worldName.toString(e, d));
            }
            case 2: {
                String save = this.save ? "and save" : "without saving";
                return String.format("unload world %s %s", this.world.toString(e, d), save);
            }
            case 3: {
                return String.format("delete world file for %s", this.worldName.toString(e, d));
            }
        }
        return String.format("load world from creator %s", this.creator.toString(e, d));
    }

    static {
        Skript.registerEffect(EffLoadWorld.class, (String[])new String[]{"load world from [[world] creator] %worldcreator%", "load world %string%", "unload [world] %world% [and (save|1:(do not|don't) save)]", "delete world file for [world] %string%"});
    }
}

