/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldCreator;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="World Creator")
@Description(value={"Create a new world creator. This will be used to create a new world.", "Name will be the name of your new world.", "Key will be how your world is represented to Minecraft. Be default this will use the Minecraft namespace. (Keys require PaperMC.)", "You can not use the name of one of the default worlds, or a world created by another plugin, such as MultiVerse.", "Copy will create a fresh new world with the same seed and settings. Clone will create a carbon copy of your world, if the world", "is large, this process may take a while. The file copying process will happen on another thread, so this won't freeze your server.", "You can optionally add `without saving` to prevent saving of the world that will be cloned. Saving freezes the server for a bit", "so this can help speed up the process... if you don't need that world saved at this moment in time.", "After creating a world creator you will need to load the world."})
@Examples(value={"set {_w} to a new world creator named \"my-world\"", "set environment of {_w} to nether", "load world from creator {_w}", "", "set {_clone} to a new world creator named \"world_clone\" to clone world \"world\" without saving", "load world from creator {_clone}"})
@Since(value={"1.8.0"})
public class ExprWorldCreator
extends SimpleExpression<BeeWorldCreator> {
    private int pattern;
    private Expression<String> name;
    private Expression<NamespacedKey> key;
    private Expression<World> world;
    private boolean clone;
    private boolean save;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.name = exprs[0];
        this.key = exprs[1];
        this.world = this.pattern == 1 ? exprs[2] : null;
        this.clone = this.pattern == 1 && parseResult.mark == 1;
        this.save = !parseResult.hasTag("save");
        return true;
    }

    protected BeeWorldCreator @Nullable [] get(@NotNull Event e) {
        NamespacedKey key;
        String name = (String)this.name.getSingle(e);
        NamespacedKey namespacedKey = key = this.key != null ? (NamespacedKey)this.key.getSingle(e) : null;
        if (name == null) {
            return null;
        }
        if (this.pattern == 0) {
            return new BeeWorldCreator[]{new BeeWorldCreator(name, key)};
        }
        if (this.pattern == 1 && this.world != null) {
            World world = (World)this.world.getSingle(e);
            if (world == null) {
                return null;
            }
            BeeWorldCreator beeWorldCreator = new BeeWorldCreator(world, name, key, this.clone);
            beeWorldCreator.setSaveClone(this.save);
            return new BeeWorldCreator[]{beeWorldCreator};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends BeeWorldCreator> getReturnType() {
        return BeeWorldCreator.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String key;
        String creator = String.format("new world creator named '%s'", this.name.toString(e, d));
        String string = key = this.key != null ? " with key " + this.key.toString(e, d) : "";
        String copy = this.pattern == 1 ? " to " + (this.clone ? "clone " : "copy ") + this.world.toString(e, d) : "";
        String withoutSaving = this.save ? "" : " without saving";
        return creator + key + copy + withoutSaving;
    }

    static {
        Skript.registerExpression(ExprWorldCreator.class, BeeWorldCreator.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] [new] world creator (with name|named) %string% [with key %-namespacedkey%]", "[a] [new] world creator (with name|named) %string% [with key %-namespacedkey%] to (copy|1:clone) %world% [save:without saving]"});
    }
}

