/*
 * Decompiled with CFR 0.152.
 */
package com.ravirai.hideRank;

import com.ravirai.hideRank.commands.HideRankCommand;
import com.ravirai.hideRank.lib.folialib.FoliaLib;
import com.ravirai.hideRank.listeners.PlayerListener;
import com.ravirai.hideRank.managers.ConfigManager;
import com.ravirai.hideRank.managers.HideRankManager;
import com.ravirai.hideRank.managers.PlayerDataManager;
import com.ravirai.hideRank.utils.Metrics;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class HideRank
extends JavaPlugin {
    private static HideRank instance;
    private static FoliaLib foliaLib;
    private ConfigManager configManager;
    private HideRankManager hideRankManager;
    private PlayerDataManager playerDataManager;
    private PlayerListener playerListener;

    public void onEnable() {
        instance = this;
        foliaLib = new FoliaLib((Plugin)this);
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.playerDataManager = new PlayerDataManager(this);
        this.hideRankManager = new HideRankManager(this, this.configManager, this.playerDataManager);
        this.getCommand("hiderank").setExecutor((CommandExecutor)new HideRankCommand(this, this.hideRankManager));
        this.playerListener = new PlayerListener(this.hideRankManager, this.playerDataManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        this.getLogger().info("HideRank has been enabled successfully!");
        this.getLogger().info("Folia support: " + (foliaLib.isFolia() ? "ENABLED" : "DISABLED"));
        this.setupBtatsMetrics();
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.getLogger().info("Vault integration enabled!");
        } else {
            this.getLogger().warning("Vault not found - HideRank will be disabled!");
        }
    }

    public void onDisable() {
        if (foliaLib != null) {
            foliaLib.getScheduler().cancelAllTasks();
        }
        this.getLogger().info("HideRank has been disabled!");
    }

    private void setupBtatsMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 27495);
    }

    public static HideRank getInstance() {
        return instance;
    }

    public static FoliaLib getFoliaLib() {
        return foliaLib;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public HideRankManager getHideRankManager() {
        return this.hideRankManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }
}

