/*
 * Decompiled with CFR 0.152.
 */
package com.ravirai.hideRank.listeners;

import com.ravirai.hideRank.HideRank;
import com.ravirai.hideRank.managers.HideRankManager;
import com.ravirai.hideRank.managers.PlayerDataManager;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final HideRankManager hideRankManager;
    private final PlayerDataManager playerDataManager;

    public PlayerListener(HideRankManager hideRankManager, PlayerDataManager playerDataManager) {
        this.hideRankManager = hideRankManager;
        this.playerDataManager = playerDataManager;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        HideRank.getFoliaLib().getScheduler().runLater(() -> {
            if (!player.isOnline()) {
                return;
            }
            PlayerDataManager.PlayerData data = this.playerDataManager.getPlayerData(player.getUniqueId());
            if (data.hideRank) {
                this.hideRankManager.applyHideRankOnJoin(player, true);
            }
        }, 40L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        HideRank.getFoliaLib().getScheduler().runLater(() -> {
            this.playerDataManager.clearCache(playerId);
            this.hideRankManager.cleanupPlayer(playerId);
        }, 100L);
    }
}

