/*
 * Decompiled with CFR 0.152.
 */
package com.ravirai.hideRank.managers;

import com.ravirai.hideRank.HideRank;
import com.ravirai.hideRank.managers.ConfigManager;
import com.ravirai.hideRank.managers.PlayerDataManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class HideRankManager {
    private final HideRank plugin;
    private final ConfigManager configManager;
    private final PlayerDataManager playerDataManager;
    private Object vaultChat = null;
    private boolean vaultAvailable = false;
    private final Map<UUID, String> originalPrefixes = new ConcurrentHashMap<UUID, String>();

    public HideRankManager(HideRank plugin, ConfigManager configManager, PlayerDataManager playerDataManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.playerDataManager = playerDataManager;
        this.setupVault();
    }

    private void setupVault() {
        if (!this.configManager.isEnabled()) {
            this.plugin.getLogger().info("HideRank system disabled in config");
            return;
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.plugin.getLogger().warning("Vault plugin not found! HideRank system disabled.");
            this.vaultAvailable = false;
            return;
        }
        try {
            Class<?> chatClass = Class.forName("net.milkbowl.vault.chat.Chat");
            RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(chatClass);
            if (rsp == null) {
                this.plugin.getLogger().warning("No Vault chat service found! HideRank system disabled.");
                this.vaultAvailable = false;
                return;
            }
            this.vaultChat = rsp.getProvider();
            boolean bl = this.vaultAvailable = this.vaultChat != null;
            if (this.vaultAvailable) {
                this.plugin.getLogger().info("HideRank system enabled with Vault integration");
            } else {
                this.plugin.getLogger().warning("Failed to setup Vault chat! HideRank system disabled.");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to setup Vault: " + e.getMessage());
            this.vaultAvailable = false;
        }
    }

    public boolean toggleHideRank(Player player) {
        if (!this.vaultAvailable) {
            player.sendMessage(this.configManager.getVaultNotFoundMessage());
            return false;
        }
        UUID playerId = player.getUniqueId();
        if (this.playerDataManager.isOnCooldown(playerId)) {
            player.sendMessage(this.configManager.getCooldownMessage());
            return false;
        }
        PlayerDataManager.PlayerData data = this.playerDataManager.getPlayerData(playerId);
        data.hideRank = !data.hideRank;
        this.playerDataManager.setCooldown(playerId);
        this.playerDataManager.savePlayerData(playerId, data);
        try {
            if (data.hideRank) {
                String currentPrefix = (String)this.vaultChat.getClass().getMethod("getPlayerPrefix", Player.class).invoke(this.vaultChat, player);
                if (currentPrefix != null && !currentPrefix.isEmpty()) {
                    this.originalPrefixes.put(playerId, currentPrefix);
                } else {
                    String primaryGroup = (String)this.vaultChat.getClass().getMethod("getPrimaryGroup", Player.class).invoke(this.vaultChat, player);
                    String groupPrefix = (String)this.vaultChat.getClass().getMethod("getGroupPrefix", World.class, String.class).invoke(this.vaultChat, player.getWorld(), primaryGroup);
                    this.originalPrefixes.put(playerId, groupPrefix != null ? groupPrefix : "");
                }
                this.vaultChat.getClass().getMethod("setPlayerPrefix", Player.class, String.class).invoke(this.vaultChat, player, this.configManager.getDefaultRank());
                player.sendMessage(this.configManager.getEnabledMessage());
            } else {
                String originalPrefix = this.originalPrefixes.get(playerId);
                if (originalPrefix != null) {
                    this.vaultChat.getClass().getMethod("setPlayerPrefix", Player.class, String.class).invoke(this.vaultChat, player, originalPrefix);
                    this.originalPrefixes.remove(playerId);
                } else {
                    String primaryGroup = (String)this.vaultChat.getClass().getMethod("getPrimaryGroup", Player.class).invoke(this.vaultChat, player);
                    String groupPrefix = (String)this.vaultChat.getClass().getMethod("getGroupPrefix", World.class, String.class).invoke(this.vaultChat, player.getWorld(), primaryGroup);
                    this.vaultChat.getClass().getMethod("setPlayerPrefix", Player.class, String.class).invoke(this.vaultChat, player, groupPrefix != null ? groupPrefix : "");
                }
                player.sendMessage(this.configManager.getDisabledMessage());
            }
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error toggling hiderank for " + player.getName() + ": " + e.getMessage());
            player.sendMessage(this.configManager.getNoChatServiceMessage());
            data.hideRank = !data.hideRank;
            this.playerDataManager.savePlayerData(playerId, data);
            return false;
        }
    }

    public void applyHideRankOnJoin(Player player, boolean shouldHide) {
        if (!this.vaultAvailable || !shouldHide) {
            return;
        }
        HideRank.getFoliaLib().getScheduler().runLater(() -> {
            if (player.isOnline()) {
                UUID playerId = player.getUniqueId();
                PlayerDataManager.PlayerData data = this.playerDataManager.getPlayerData(playerId);
                if (data.hideRank) {
                    try {
                        this.vaultChat.getClass().getMethod("setPlayerPrefix", Player.class, String.class).invoke(this.vaultChat, player, this.configManager.getDefaultRank());
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to apply hiderank on join for " + player.getName());
                    }
                }
            }
        }, 20L);
    }

    public void cleanupPlayer(UUID playerId) {
        this.originalPrefixes.remove(playerId);
    }

    public boolean isVaultAvailable() {
        return this.vaultAvailable;
    }
}

