/*
 * Decompiled with CFR 0.152.
 */
package com.ravirai.hideRank.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ravirai.hideRank.HideRank;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerDataManager {
    private final HideRank plugin;
    private final File dataFolder;
    private final Gson gson;
    private final Map<UUID, PlayerData> cache = new ConcurrentHashMap<UUID, PlayerData>();
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();

    public PlayerDataManager(HideRank plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "playerdata");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
    }

    public PlayerData getPlayerData(UUID playerId) {
        PlayerData cached = this.cache.get(playerId);
        if (cached != null) {
            return cached;
        }
        PlayerData data = this.loadPlayerData(playerId);
        this.cache.put(playerId, data);
        return data;
    }

    private PlayerData loadPlayerData(UUID playerId) {
        PlayerData playerData;
        File file = new File(this.dataFolder, playerId.toString() + ".json");
        if (!file.exists()) {
            return new PlayerData();
        }
        FileReader reader = new FileReader(file);
        try {
            PlayerData data = (PlayerData)this.gson.fromJson((Reader)reader, PlayerData.class);
            playerData = data != null ? data : new PlayerData();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load player data for " + String.valueOf(playerId) + ": " + e.getMessage());
                return new PlayerData();
            }
        }
        reader.close();
        return playerData;
    }

    public void savePlayerData(UUID playerId, PlayerData data) {
        this.cache.put(playerId, data);
        HideRank.getFoliaLib().getScheduler().runAsync(task -> {
            File file = new File(this.dataFolder, playerId.toString() + ".json");
            try (FileWriter writer = new FileWriter(file);){
                this.gson.toJson((Object)data, (Appendable)writer);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save player data for " + String.valueOf(playerId) + ": " + e.getMessage());
            }
        });
    }

    public boolean isOnCooldown(UUID playerId) {
        Long lastUse = this.cooldowns.get(playerId);
        if (lastUse == null) {
            return false;
        }
        return System.currentTimeMillis() - lastUse < 5000L;
    }

    public void setCooldown(UUID playerId) {
        this.cooldowns.put(playerId, System.currentTimeMillis());
    }

    public void clearCache(UUID playerId) {
        this.cache.remove(playerId);
        this.cooldowns.remove(playerId);
    }

    public static class PlayerData {
        public boolean hideRank = false;
    }
}

