package de.keksuccino.justnicks.platform;

import com.mojang.blaze3d.platform.InputConstants;
import de.keksuccino.justnicks.JustNicksNeoForgePermissions;
import de.keksuccino.justnicks.platform.services.IPlatformHelper;
import de.keksuccino.justnicks.util.permission.Permission;
import net.minecraft.client.KeyMapping;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NeoForgePlatformHelper implements IPlatformHelper {

    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public String getPlatformName() {
        return "neoforge";
    }

    @Override
    public String getPlatformDisplayName() {
        return "NeoForge";
    }

    @Override
    public String getLoaderVersion() {
        return this.getModVersion("neoforge");
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public String getModVersion(String modId) {
        try {
            Optional<? extends ModContainer> o = ModList.get().getModContainerById(modId);
            if (o.isPresent()) {
                ModContainer c = o.get();
                return c.getModInfo().getVersion().toString();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "0.0.0";
    }

    @Override
    public List<String> getLoadedModIds() {
        List<String> l = new ArrayList<>();
        for (IModInfo info : ModList.get().getMods()) {
            l.add(info.getModId());
        }
        return l;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.getCurrent().isProduction();
    }

    @Override
    public boolean isOnClient() {
        return FMLEnvironment.getDist() == Dist.CLIENT;
    }

    @Override
    public InputConstants.Key getKeyMappingKey(KeyMapping keyMapping) {
        return keyMapping.getKey();
    }

    @Override
    public boolean hasPermission(@Nullable ServerPlayer player, @NotNull Permission permission) {
        if (player == null) return false;
        try {
            return PermissionAPI.getPermission(player, Objects.requireNonNull(JustNicksNeoForgePermissions.resolveNode(permission)));
        } catch (Exception ex) {
            LOGGER.error("[JUST NICKS] Failed to check player permissions on NeoForge!", ex);
        }
        return false;
    }

}