/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.simpleemotes.forge.networking.client;

import aquariusplayz.simpleemotes.common.interfaces.IPlayer;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class AnimationPacketFromServer {
    private int value;
    private UUID uuid;

    public AnimationPacketFromServer(FriendlyByteBuf buf) {
        this.value = buf.readInt();
        this.uuid = buf.readUUID();
    }

    public AnimationPacketFromServer(int i, UUID uuid) {
        this.value = i;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.value);
        buf.writeUUID(this.uuid);
    }

    public void handle(CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            if (FMLEnvironment.dist.isClient()) {
                this.playerChanged();
            }
        });
        ctx.setPacketHandled(true);
    }

    public void playerChanged() {
        for (Player target : Minecraft.getInstance().level.players()) {
            if (!target.getUUID().equals(this.uuid) || Minecraft.getInstance().player.getUUID().equals(target.getUUID())) continue;
            if (this.value == 1) {
                ((IPlayer)target).wave().start(target.tickCount);
                continue;
            }
            if (this.value == 2) {
                ((IPlayer)target).yes().start(target.tickCount);
                continue;
            }
            if (this.value == 3) {
                ((IPlayer)target).no().start(target.tickCount);
                continue;
            }
            if (this.value == 4) {
                ((IPlayer)target).dontknow().start(target.tickCount);
                continue;
            }
            if (this.value == 5) {
                ((IPlayer)target).facepalm().start(target.tickCount);
                continue;
            }
            if (this.value == 6) {
                ((IPlayer)target).applaud().start(target.tickCount);
                continue;
            }
            if (this.value == 7) {
                ((IPlayer)target).cheer().start(target.tickCount);
                continue;
            }
            if (this.value == 8) {
                ((IPlayer)target).cry().start(target.tickCount);
                continue;
            }
            if (this.value != 9) continue;
            ((IPlayer)target).laugh().start(target.tickCount);
        }
    }
}

