/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.simpleemotes.neoforged.mixin;

import aquariusplayz.simpleemotes.common.client.tools.PlayerAnimations;
import aquariusplayz.simpleemotes.common.client.tools.Tools;
import aquariusplayz.simpleemotes.common.interfaces.IPlayer;
import aquariusplayz.simpleemotes.common.interfaces.IPlayerRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class}, remap=false)
public abstract class PlayerModelMixin
extends HumanoidModel<AvatarRenderState> {
    private KeyframeAnimation waveAnimation;
    private KeyframeAnimation yesAnimation;
    private KeyframeAnimation noAnimation;
    private KeyframeAnimation dontknowAnimation;
    private KeyframeAnimation facepalmAnimation;
    private KeyframeAnimation applaudAnimation;
    private KeyframeAnimation cheerAnimation;
    private KeyframeAnimation cryAnimation;
    private KeyframeAnimation laughAnimation;

    public PlayerModelMixin(ModelPart p_170677_) {
        super(p_170677_);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void PlayerModelConstructor(ModelPart part, boolean slim, CallbackInfo ci) {
        this.waveAnimation = PlayerAnimations.wave.bake(part);
        this.yesAnimation = PlayerAnimations.yes.bake(part);
        this.noAnimation = PlayerAnimations.no.bake(part);
        this.dontknowAnimation = PlayerAnimations.dont_know.bake(part);
        this.facepalmAnimation = PlayerAnimations.facepalm.bake(part);
        this.applaudAnimation = PlayerAnimations.applaud.bake(part);
        this.cheerAnimation = PlayerAnimations.cheer.bake(part);
        this.cryAnimation = PlayerAnimations.cry.bake(part);
        this.laughAnimation = PlayerAnimations.laugh.bake(part);
        System.out.println("Emote animations added!");
    }

    @Inject(at={@At(value="TAIL")}, method={"setupAnim"})
    public void setupAnim(AvatarRenderState state, CallbackInfo ci) {
        if (!state.isPassenger) {
            Player player = ((IPlayerRenderState)state).player();
            if (!Tools.animationEnded(((IPlayer)player).wave(), (Entity)player, 2.58f)) {
                this.rightArm.setRotation(0.0f, 0.0f, 0.0f);
                this.waveAnimation.apply(((IPlayer)player).wave(), state.ageInTicks);
            }
            if (!Tools.animationEnded(((IPlayer)player).yes(), (Entity)player, 1.25f)) {
                this.yesAnimation.apply(((IPlayer)player).yes(), state.ageInTicks);
            }
            if (!Tools.animationEnded(((IPlayer)player).no(), (Entity)player, 1.71f)) {
                this.noAnimation.apply(((IPlayer)player).no(), state.ageInTicks);
            }
            if (!Tools.animationEnded(((IPlayer)player).dontknow(), (Entity)player, 1.25f)) {
                this.rightArm.setRotation(0.0f, 0.0f, 0.0f);
                this.leftArm.setRotation(0.0f, 0.0f, 0.0f);
                this.dontknowAnimation.apply(((IPlayer)player).dontknow(), state.ageInTicks);
            }
            if (!Tools.animationEnded(((IPlayer)player).facepalm(), (Entity)player, 2.25f)) {
                this.rightArm.setRotation(0.0f, 0.0f, 0.0f);
                this.facepalmAnimation.apply(((IPlayer)player).facepalm(), state.ageInTicks);
            }
            if (!Tools.animationEnded(((IPlayer)player).applaud(), (Entity)player, 1.58f)) {
                this.rightArm.setRotation(0.0f, 0.0f, 0.0f);
                this.leftArm.setRotation(0.0f, 0.0f, 0.0f);
                this.applaudAnimation.apply(((IPlayer)player).applaud(), state.ageInTicks);
            }
            if (!Tools.animationEnded(((IPlayer)player).cheer(), (Entity)player, 1.25f)) {
                this.body.setRotation(0.0f, 0.0f, 0.0f);
                this.rightArm.setRotation(0.0f, 0.0f, 0.0f);
                this.leftArm.setRotation(0.0f, 0.0f, 0.0f);
                this.rightLeg.setRotation(0.0f, 0.0f, 0.0f);
                this.leftLeg.setRotation(0.0f, 0.0f, 0.0f);
                this.cheerAnimation.apply(((IPlayer)player).cheer(), state.ageInTicks);
            }
            if (!Tools.animationEnded(((IPlayer)player).cry(), (Entity)player, 2.5f)) {
                this.rightArm.setRotation(0.0f, 0.0f, 0.0f);
                this.leftArm.setRotation(0.0f, 0.0f, 0.0f);
                this.cryAnimation.apply(((IPlayer)player).cry(), state.ageInTicks);
            }
            if (!Tools.animationEnded(((IPlayer)player).laugh(), (Entity)player, 2.5f)) {
                this.body.setRotation(0.0f, 0.0f, 0.0f);
                this.rightArm.setRotation(0.0f, 0.0f, 0.0f);
                this.leftArm.setRotation(0.0f, 0.0f, 0.0f);
                this.laughAnimation.apply(((IPlayer)player).laugh(), state.ageInTicks);
            }
        }
    }
}

