/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.block;

import gavinx.temperatureapi.api.TemperatureAPI;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import xyz.srgnis.bodyhealthsystem.block.SpaceHeaterBlock;
import xyz.srgnis.bodyhealthsystem.client.screen.SpaceHeaterScreenHandler;
import xyz.srgnis.bodyhealthsystem.registry.ModBlocks;

public class SpaceHeaterBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
class_1263 {
    private final class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private int burnTime = 0;
    private int burnTimeTotal = 0;
    private boolean regulate = false;
    private double consumeDebt = 0.0;
    public static final int SLOT_FUEL = 0;
    private static final class_2561 TITLE = class_2561.method_43471((String)"block.bodyhealthsystem.space_heater");
    private final class_3913 properties = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> SpaceHeaterBlockEntity.this.burnTime;
                case 1 -> SpaceHeaterBlockEntity.this.burnTimeTotal;
                case 2 -> {
                    if (SpaceHeaterBlockEntity.this.regulate) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                SpaceHeaterBlockEntity.this.burnTime = value;
            } else if (index == 1) {
                SpaceHeaterBlockEntity.this.burnTimeTotal = value;
            } else if (index == 2) {
                SpaceHeaterBlockEntity.this.regulate = value != 0;
            }
        }

        public int method_17389() {
            return 3;
        }
    };

    public SpaceHeaterBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.SPACE_HEATER_BE, pos, state);
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getBurnTimeTotal() {
        return this.burnTimeTotal;
    }

    public boolean isRegulating() {
        return this.regulate;
    }

    public void setRegulating(boolean v) {
        this.regulate = v;
        this.method_5431();
    }

    public int getComparatorValue() {
        return Math.min(15, (int)Math.round((this.burnTimeTotal == 0 ? 0.0 : (double)this.burnTime / (double)this.burnTimeTotal) * 15.0));
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, SpaceHeaterBlockEntity be) {
        boolean isBurning;
        int burn;
        class_1799 stack;
        boolean wasLit;
        Boolean has;
        if (world.field_9236) {
            return;
        }
        if (state.method_26204() instanceof SpaceHeaterBlock && (has = Boolean.valueOf(state.method_28498((class_2769)SpaceHeaterBlock.REGULATE))).booleanValue() && (Boolean)state.method_11654((class_2769)SpaceHeaterBlock.REGULATE) != be.regulate) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)SpaceHeaterBlock.REGULATE, (Comparable)Boolean.valueOf(be.regulate)), 3);
            state = world.method_8320(pos);
        }
        double envC = Double.NaN;
        boolean wantsHeating = !be.regulate ? true : !Double.isNaN(envC = TemperatureAPI.getEnvironmentCelsius((class_1937)world, (class_2338)pos)) && envC < 22.0;
        boolean bl = wasLit = state.method_28498((class_2769)class_2741.field_12548) && (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false;
        if (be.burnTime <= 0 && wantsHeating && !(stack = (class_1799)be.items.get(0)).method_7960() && (burn = SpaceHeaterBlockEntity.getFuelBurnTime(stack.method_7909())) > 0) {
            stack.method_7934(1);
            be.burnTime = burn;
            be.burnTimeTotal = burn;
            be.method_5431();
        }
        if (be.burnTime > 0 && wantsHeating) {
            int burn2;
            class_1799 stack2;
            double deficit;
            int consume = 1;
            if (be.regulate && !Double.isNaN(envC) && (deficit = Math.max(0.0, 22.0 - envC)) > 0.0) {
                double rate = 1.0 + 0.05 * deficit;
                double total = rate + be.consumeDebt;
                int units = (int)Math.floor(total);
                be.consumeDebt = total - (double)units;
                consume = Math.max(1, units);
            }
            be.burnTime -= consume;
            if (be.burnTime < 0) {
                be.burnTime = 0;
            }
            if (be.burnTime <= 0 && wantsHeating && !(stack2 = (class_1799)be.items.get(0)).method_7960() && (burn2 = SpaceHeaterBlockEntity.getFuelBurnTime(stack2.method_7909())) > 0) {
                stack2.method_7934(1);
                be.burnTime = burn2;
                be.burnTimeTotal = burn2;
                be.method_5431();
            }
        }
        boolean bl2 = isBurning = be.burnTime > 0 && wantsHeating;
        if (wasLit != isBurning && state.method_28498((class_2769)class_2741.field_12548)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(isBurning)), 3);
        }
    }

    private static int getFuelBurnTime(class_1792 item) {
        if (item == class_1802.field_8665) {
            return 1600;
        }
        if (item == class_1802.field_8713) {
            return 1600;
        }
        if (item == class_1802.field_8797) {
            return 16000;
        }
        return 0;
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("Burn", this.burnTime);
        nbt.method_10569("BurnTotal", this.burnTimeTotal);
        nbt.method_10556("Regulate", this.regulate);
        class_1262.method_5426((class_2487)nbt, this.items);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.burnTime = nbt.method_10550("Burn");
        this.burnTimeTotal = nbt.method_10550("BurnTotal");
        this.regulate = nbt.method_10577("Regulate");
        class_1262.method_5429((class_2487)nbt, this.items);
    }

    public void onBroken(class_1937 world, class_2338 pos) {
        class_1799 stack = (class_1799)this.items.get(0);
        if (!stack.method_7960()) {
            class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)class_2371.method_10213((int)1, (Object)stack));
        }
    }

    public class_2561 method_5476() {
        return TITLE;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new SpaceHeaterScreenHandler(syncId, inv, this, this.properties, this.field_11867);
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        return ((class_1799)this.items.get(0)).method_7960();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 res = class_1262.method_5430(this.items, (int)slot, (int)amount);
        if (!res.method_7960()) {
            this.method_5431();
        }
        return res;
    }

    public class_1799 method_5441(int slot) {
        class_1799 res = class_1262.method_5428(this.items, (int)slot);
        if (!res.method_7960()) {
            this.method_5431();
        }
        return res;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
        if (stack.method_7947() > stack.method_7914()) {
            stack.method_7939(stack.method_7914());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.items.set(0, (Object)class_1799.field_8037);
    }

    public class_3913 getProperties() {
        return this.properties;
    }

    public static boolean isValidFuel(class_1799 stack) {
        return SpaceHeaterBlockEntity.getFuelBurnTime(stack.method_7909()) > 0;
    }
}

