/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.body;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import xyz.srgnis.bodyhealthsystem.body.BodyBuckets;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.mixin.ModifyAppliedDamageInvoker;
import xyz.srgnis.bodyhealthsystem.network.ServerNetworking;
import xyz.srgnis.bodyhealthsystem.registry.ModStatusEffects;
import xyz.srgnis.bodyhealthsystem.util.Utils;

public abstract class Body {
    protected final HashMap<class_2960, BodyPart> parts = new HashMap();
    protected HashMap<class_2960, BodyPart> noCriticalParts = new HashMap();
    protected final HashMap<class_2960, Float> absorptionBuckets = new HashMap();
    protected final HashMap<class_2960, Float> boostBuckets = new HashMap();
    protected class_1309 entity;
    private final BodyBuckets buckets = new BodyBuckets(this);
    protected boolean suppressBoneBreakEvaluation = false;
    protected boolean suppressWoundEvaluation = false;
    protected int boneGraceTicksRemaining = 0;
    protected boolean bonePenaltyActive = false;
    protected int bonePenaltyTickCounter = 0;
    protected boolean downed = false;
    protected int bleedOutTicksRemaining = 0;
    protected boolean beingRevived = false;
    protected UUID reviverUuid = null;
    protected boolean pendingDeath = false;

    public abstract void initParts();

    public void addPart(class_2960 identifier, BodyPart part) {
        this.parts.put(identifier, part);
        this.absorptionBuckets.put(identifier, Float.valueOf(0.0f));
        this.boostBuckets.put(identifier, Float.valueOf(0.0f));
        this.buckets.onPartAdded(identifier);
    }

    public BodyPart getPart(class_2960 identifier) {
        return this.parts.get(identifier);
    }

    public void removePart(class_2960 identifier) {
        this.parts.remove(identifier);
    }

    public ArrayList<BodyPart> getParts() {
        return new ArrayList<BodyPart>(this.parts.values());
    }

    public ArrayList<class_2960> getPartsIdentifiers() {
        return new ArrayList<class_2960>(this.parts.keySet());
    }

    public ArrayList<BodyPart> getNoCriticalParts() {
        return new ArrayList<BodyPart>(this.noCriticalParts.values());
    }

    public ArrayList<class_2960> getNoCriticalIdentifiers() {
        return new ArrayList<class_2960>(this.noCriticalParts.keySet());
    }

    public void writeToNbt(class_2487 nbt) {
        class_2487 new_nbt = new class_2487();
        for (BodyPart part : this.getParts()) {
            part.writeToNbt(new_nbt);
        }
        new_nbt.method_10556("downed", this.downed);
        new_nbt.method_10569("bleedOutTicksRemaining", this.bleedOutTicksRemaining);
        nbt.method_10566("bodyhealthsystem", (class_2520)new_nbt);
    }

    public void readFromNbt(class_2487 nbt) {
        class_2487 bodyNbt = nbt.method_10562("bodyhealthsystem");
        if (!bodyNbt.method_33133()) {
            this.noCriticalParts.clear();
            for (class_2960 partId : this.getPartsIdentifiers()) {
                if (bodyNbt.method_10562(partId.toString()).method_33133()) continue;
                BodyPart part = this.getPart(partId);
                part.readFromNbt(bodyNbt.method_10562(partId.toString()));
                if (!(part.getHealth() > 0.0f)) continue;
                this.noCriticalParts.put(part.getIdentifier(), part);
            }
            if (bodyNbt.method_10545("downed")) {
                this.downed = bodyNbt.method_10577("downed");
            }
            if (bodyNbt.method_10545("bleedOutTicksRemaining")) {
                this.bleedOutTicksRemaining = bodyNbt.method_10550("bleedOutTicksRemaining");
            } else if (this.downed && this.bleedOutTicksRemaining <= 0) {
                this.bleedOutTicksRemaining = this.isTorsoBroken() ? 800 : 1600;
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Body of " + this.entity.method_5477().getString() + "\n");
        for (BodyPart p : this.getParts()) {
            s.append(p.toString());
        }
        return s.toString();
    }

    public void healAll() {
        for (BodyPart part : this.getParts()) {
            part.heal();
        }
    }

    public void heal(float amount) {
        if (amount > 0.0f) {
            ArrayList<BodyPart> parts_l = this.getParts();
            Collections.shuffle(parts_l);
            for (BodyPart part : parts_l) {
                if (amount <= 0.0f) break;
                amount = part.heal(amount);
            }
        }
    }

    public void healPart(int amount, class_2960 partID) {
        this.healPart((float)amount, this.getPart(partID));
    }

    public void healPart(float amount, BodyPart part) {
        part.heal(amount);
    }

    public void applyDamageBySource(float amount, class_1282 source) {
        this.applyDamageLocalRandom(amount, source);
    }

    public void applyDamageLocal(float amount, class_1282 source, BodyPart part) {
        this.takeDamage(amount, source, part);
    }

    public void applyDamageLocalRandom(float amount, class_1282 source) {
        this.takeDamage(amount, source, this.getNoCriticalParts().get(this.entity.method_6051().method_43048(this.noCriticalParts.size())));
    }

    public void applyDamageGeneral(float amount, class_1282 source) {
        this.applyDamageList(amount, source, this.getParts());
    }

    public void applyDamageGeneralRandom(float amount, class_1282 source) {
        this.applyDamageListRandom(amount, source, this.getParts());
    }

    public void applyDamageList(float amount, class_1282 source, List<BodyPart> parts) {
        float split_amount = amount / (float)parts.size();
        for (BodyPart bodyPart : parts) {
            this.takeDamage(split_amount, source, bodyPart);
        }
    }

    public void applyDamageListRandom(float amount, class_1282 source, List<BodyPart> parts) {
        List<Float> damages = Utils.n_random(amount, parts.size());
        int i = 0;
        for (BodyPart bodyPart : parts) {
            this.takeDamage(damages.get(i).floatValue(), source, bodyPart);
            ++i;
        }
    }

    public void applyDamageRandomList(float amount, class_1282 source) {
        List<BodyPart> randomlist = Utils.random_sublist(this.getNoCriticalParts(), this.entity.method_6051().method_43048(this.getNoCriticalParts().size() + 1));
        this.applyDamageList(amount, source, randomlist);
    }

    public void applyDamageFullRandom(float amount, class_1282 source) {
        List<BodyPart> randomlist = Utils.random_sublist(this.getNoCriticalParts(), this.entity.method_6051().method_43048(this.getNoCriticalParts().size() + 1));
        this.applyDamageListRandom(amount, source, randomlist);
    }

    public float takeDamage(float amount, class_1282 source, BodyPart part) {
        class_1309 class_13092;
        amount = this.applyArmorToDamage(source, amount, part);
        float f = amount = ((ModifyAppliedDamageInvoker)this.entity).invokeModifyAppliedDamage(source, amount);
        this.ensureAbsorptionBucketsUpToDate();
        float currentAbs = this.entity.method_6067();
        float bucket = this.getAbsorptionBucket(part);
        float consumed = Math.min(amount, bucket);
        if (consumed > 0.0f) {
            this.consumeAbsorptionFromBucket(part, consumed);
            this.entity.method_6073(Math.max(0.0f, currentAbs - consumed));
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_3222) {
                class_3222 spe = (class_3222)class_12972;
                spe.method_7339(class_3468.field_15408, Math.round(consumed * 10.0f));
            }
            if ((class_12972 = this.entity) instanceof class_1657) {
                class_1657 selfPlayer = (class_1657)class_12972;
                selfPlayer.method_7339(class_3468.field_15365, Math.round(consumed * 10.0f));
            }
            amount -= consumed;
        }
        if (amount == 0.0f) {
            return 0.0f;
        }
        float previousHealth = part.getHealth();
        float remaining = source.method_49708(class_8111.field_42349) && this.entity.method_6112(class_1294.field_5899) != null ? part.damageWithoutKill(amount) : part.damage(amount);
        if (!part.getIdentifier().equals((Object)PlayerBodyParts.HEAD) && !this.suppressBoneBreakEvaluation && !this.suppressWoundEvaluation && Config.enableBoneSystem) {
            this.evaluateBoneBreak(part, previousHealth, amount);
        }
        if ((class_13092 = this.entity) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            player.method_7322(source.method_5528());
            if (amount < 3.4028235E37f) {
                player.method_7339(class_3468.field_15388, Math.round(amount * 10.0f));
            }
        }
        this.entity.method_6066().method_5547(source, amount);
        this.entity.method_32876(class_5712.field_28736);
        return remaining;
    }

    private void evaluateBoneBreak(BodyPart part, float previousHealth, float rawDamage) {
        float baseChance;
        float max = part.getMaxHealth();
        float newHealth = part.getHealth();
        if (newHealth <= 0.0f) {
            part.setBroken(true);
            if (this.isArm(part)) {
                this.assignArmBrokenHalf(part);
            }
            return;
        }
        float healthRatio = previousHealth / max;
        if (healthRatio >= 0.6f) {
            baseChance = 0.0f;
        } else {
            float t = (0.6f - healthRatio) / 0.6f;
            baseChance = 0.15f * (float)Math.pow(t, 2.0);
        }
        float damageRatio = Math.min(rawDamage / max, 1.0f);
        float bonus = 0.1f * damageRatio;
        float chance = Math.min(0.5f, baseChance + bonus);
        if (this.entity.method_6051().method_43057() < chance) {
            part.setBroken(true);
            if (this.isArm(part)) {
                this.assignArmBrokenHalf(part);
            }
        }
    }

    private boolean isArm(BodyPart part) {
        class_2960 id = part.getIdentifier();
        return id.equals((Object)PlayerBodyParts.LEFT_ARM) || id.equals((Object)PlayerBodyParts.RIGHT_ARM);
    }

    private void assignArmBrokenHalf(BodyPart part) {
        if (part.getBrokenTopHalf() == null) {
            part.setBrokenTopHalf(this.entity.method_6051().method_43056());
        }
    }

    public abstract float applyArmorToDamage(class_1282 var1, float var2, BodyPart var3);

    public void applyBrokenBonesEffects() {
        int fatigueAmp;
        int slowAmp;
        int weakAmp;
        boolean anyImpaired;
        class_1309 class_13092 = this.entity;
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        if (this.entity.method_37908().field_9236) {
            return;
        }
        if (!Config.enableBoneSystem) {
            return;
        }
        int impairedArms = 0;
        int impairedLegsFeet = 0;
        for (BodyPart p : this.getParts()) {
            boolean impaired;
            class_2960 id = p.getIdentifier();
            if (id.equals((Object)PlayerBodyParts.HEAD) || !(impaired = p.isBroken() || p.getHealth() <= 0.0f)) continue;
            if (id.equals((Object)PlayerBodyParts.LEFT_ARM) || id.equals((Object)PlayerBodyParts.RIGHT_ARM)) {
                ++impairedArms;
            }
            if (!id.equals((Object)PlayerBodyParts.LEFT_LEG) && !id.equals((Object)PlayerBodyParts.RIGHT_LEG) && !id.equals((Object)PlayerBodyParts.LEFT_FOOT) && !id.equals((Object)PlayerBodyParts.RIGHT_FOOT)) continue;
            ++impairedLegsFeet;
        }
        boolean bl = anyImpaired = impairedArms + impairedLegsFeet > 0;
        if (!this.anyBoneBroken() && !anyImpaired) {
            this.bonePenaltyActive = false;
            this.boneGraceTicksRemaining = 0;
            this.bonePenaltyTickCounter = 0;
            player.method_6016(class_1294.field_5909);
            player.method_6016(class_1294.field_5901);
            player.method_6016(class_1294.field_5911);
            player.method_6016(ModStatusEffects.BLEEDING_EFFECT);
            return;
        }
        if (!this.bonePenaltyActive) {
            if (this.boneGraceTicksRemaining > 0) {
                --this.boneGraceTicksRemaining;
            } else {
                this.bonePenaltyActive = true;
                this.bonePenaltyTickCounter = 0;
            }
        }
        int totalBroken = 0;
        boolean boneStateChanged = false;
        for (BodyPart p : this.getParts()) {
            if (p.getIdentifier().equals((Object)PlayerBodyParts.HEAD) || !p.isBroken()) continue;
            p.tickBroken();
            if (p.getBrokenTicks() == 2400 && !p.isFractureLocked()) {
                if (p.getHealth() > 0.0f) {
                    p.setHealth(0.0f);
                }
                p.setFractureLocked(true);
                boneStateChanged = true;
            }
            ++totalBroken;
        }
        if (boneStateChanged) {
            ServerNetworking.broadcastBody((class_1297)player);
        }
        if (totalBroken > 0) {
            int stacks = Math.min(3, totalBroken);
            int maxBrokenTicks = 0;
            for (BodyPart p : this.getParts()) {
                if (p.getIdentifier().equals((Object)PlayerBodyParts.HEAD) || !p.isBroken()) continue;
                maxBrokenTicks = Math.max(maxBrokenTicks, p.getBrokenTicks());
            }
            if (maxBrokenTicks >= 300) {
                player.method_6092(new class_1293(ModStatusEffects.BROKEN_BONE, 40, stacks - 1, false, true, true));
            } else {
                player.method_6016(ModStatusEffects.BROKEN_BONE);
            }
        } else {
            player.method_6016(ModStatusEffects.BROKEN_BONE);
        }
        int n = impairedArms >= 2 ? 1 : (weakAmp = impairedArms >= 1 ? 0 : -1);
        int n2 = impairedLegsFeet >= 2 ? 1 : (slowAmp = impairedLegsFeet >= 1 ? 0 : -1);
        int n3 = impairedArms + impairedLegsFeet >= 2 ? 0 : (impairedArms + impairedLegsFeet >= 4 ? 1 : (fatigueAmp = impairedArms + impairedLegsFeet >= 1 ? 0 : -1));
        if (slowAmp >= 0) {
            player.method_6092(new class_1293(class_1294.field_5909, 40, slowAmp, false, false, true));
        } else {
            player.method_6016(class_1294.field_5909);
        }
        if (weakAmp >= 0) {
            player.method_6092(new class_1293(class_1294.field_5911, 40, weakAmp, false, false, true));
        } else {
            player.method_6016(class_1294.field_5911);
        }
        if (fatigueAmp >= 0) {
            player.method_6092(new class_1293(class_1294.field_5901, 40, fatigueAmp, false, false, true));
        } else {
            player.method_6016(class_1294.field_5901);
        }
        if (this.bonePenaltyActive) {
            ++this.bonePenaltyTickCounter;
            if (this.bonePenaltyTickCounter >= 200) {
                this.bonePenaltyTickCounter = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyBleedingDamageTo(class_1657 player, BodyPart target, float amount) {
        if (target == null || amount <= 0.0f) {
            return;
        }
        this.suppressBoneBreakEvaluation = true;
        this.suppressWoundEvaluation = true;
        try {
            this.takeDamage(amount, player.method_48923().method_48830(), target);
        }
        finally {
            this.suppressBoneBreakEvaluation = false;
            this.suppressWoundEvaluation = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyNonBreakingDamage(float amount, class_1282 source, BodyPart target) {
        if (target == null || amount <= 0.0f) {
            return;
        }
        this.suppressBoneBreakEvaluation = true;
        this.suppressWoundEvaluation = true;
        try {
            this.takeDamage(amount, source, target);
        }
        finally {
            this.suppressBoneBreakEvaluation = false;
            this.suppressWoundEvaluation = false;
        }
    }

    public void applyBleedingWithSpill(float amount, BodyPart target) {
        boolean targetIsTorso;
        class_1309 class_13092 = this.entity;
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        if (amount <= 0.0f || target == null) {
            return;
        }
        BodyPart head = this.getPart(PlayerBodyParts.HEAD);
        BodyPart torso = this.getPart(PlayerBodyParts.TORSO);
        boolean bl = targetIsTorso = torso != null && target.getIdentifier().equals((Object)torso.getIdentifier());
        if (targetIsTorso) {
            ArrayList<BodyPart> limbs = new ArrayList<BodyPart>();
            for (BodyPart p : this.getParts()) {
                if (p == torso || p == head || p.getHealth() <= 0.0f) continue;
                limbs.add(p);
            }
            class_5819 rnd = this.entity.method_6051();
            while (amount > 0.0f && !limbs.isEmpty()) {
                BodyPart limb = (BodyPart)limbs.get(rnd.method_43048(limbs.size()));
                float hpL = limb.getHealth();
                if (hpL <= 0.0f) {
                    limbs.remove(limb);
                    continue;
                }
                float apply = Math.min(amount, hpL);
                this.applyBleedingDamageTo(player, limb, apply);
                amount -= apply;
                if (!(apply >= hpL)) continue;
                limbs.remove(limb);
            }
            if (amount > 0.0f && torso != null && torso.getHealth() > 0.0f) {
                float apply = Math.min(amount, torso.getHealth());
                this.applyBleedingDamageTo(player, torso, apply);
                amount -= apply;
            }
            return;
        }
        float hp = target.getHealth();
        if (hp > 0.0f) {
            float apply = Math.min(amount, hp);
            this.applyBleedingDamageTo(player, target, apply);
            amount -= apply;
        }
        if (amount <= 0.0f) {
            return;
        }
        ArrayList<BodyPart> limbCandidates = new ArrayList<BodyPart>();
        ArrayList<BodyPart> torsoCandidate = new ArrayList<BodyPart>();
        for (BodyPart p : this.getParts()) {
            if (p == target || p.getHealth() <= 0.0f) continue;
            class_2960 id = p.getIdentifier();
            if (head != null && id.equals((Object)head.getIdentifier())) continue;
            if (torso != null && id.equals((Object)torso.getIdentifier())) {
                torsoCandidate.add(p);
                continue;
            }
            limbCandidates.add(p);
        }
        BodyPart spill = null;
        if (!limbCandidates.isEmpty()) {
            spill = (BodyPart)limbCandidates.get(this.entity.method_6051().method_43048(limbCandidates.size()));
        } else if (!torsoCandidate.isEmpty()) {
            spill = (BodyPart)torsoCandidate.get(0);
        } else if (head != null && head.getHealth() > 0.0f) {
            spill = head;
        }
        if (spill == null) {
            return;
        }
        this.applyBleedingDamageTo(player, spill, amount);
    }

    public void applyStatusEffectWithAmplifier(class_1291 effect, int amplifier) {
        if (amplifier >= 0) {
            class_1293 s = this.entity.method_6112(effect);
            if (s == null) {
                this.entity.method_6092(new class_1293(effect, 40, amplifier));
            } else if (s.method_5578() > amplifier || s.method_5584() <= 5 || s.method_5578() != amplifier) {
                this.entity.method_6092(new class_1293(effect, 40, amplifier));
            }
        }
    }

    public int getAmplifier(BodyPart part) {
        if (part.getHealth() <= part.getCriticalThreshold()) {
            return 1;
        }
        return 0;
    }

    public void updateHealth() {
        BodyPart head = this.getPart(PlayerBodyParts.HEAD);
        BodyPart torso = this.getPart(PlayerBodyParts.TORSO);
        if (head != null && head.getHealth() <= 0.0f) {
            this.entity.method_6033(0.0f);
            return;
        }
        if (torso != null && torso.getHealth() <= 0.0f) {
            this.startDowned();
            if (this.entity.method_6032() < 1.0f) {
                this.entity.method_6033(1.0f);
            }
            return;
        }
        float max_effective = 0.0f;
        float actual_health = 0.0f;
        for (BodyPart part : this.getParts()) {
            float boost = this.getBoostForPart(part.getIdentifier());
            max_effective += part.getMaxHealth() + Math.max(0.0f, boost);
            actual_health += part.getHealth();
        }
        if (max_effective > 0.0f) {
            float ratio = actual_health / max_effective;
            if (ratio <= 0.01f) {
                this.startDowned();
                if (this.entity.method_6032() > 1.0f) {
                    this.entity.method_6033(1.0f);
                }
                return;
            }
            this.entity.method_6033(this.entity.method_6063() * ratio);
        }
    }

    public boolean shouldDie() {
        BodyPart head = this.getPart(PlayerBodyParts.HEAD);
        return head != null && head.getHealth() <= 0.0f;
    }

    public void checkNoCritical(BodyPart part) {
        if (part.getHealth() > 0.0f) {
            this.noCriticalParts.putIfAbsent(part.getIdentifier(), part);
        } else {
            this.noCriticalParts.remove(part.getIdentifier());
        }
    }

    public void applyTotem() {
        for (BodyPart part : this.getParts()) {
            if (!(part.getHealth() < 1.0f)) continue;
            part.setHealth(1.0f);
        }
        this.updateHealth();
    }

    public void onBoneBrokenEvent(BodyPart part) {
        this.boneGraceTicksRemaining = this.boneGraceTicksRemaining <= 0 && !this.bonePenaltyActive ? 2400 : Math.max(0, this.boneGraceTicksRemaining - 600);
        class_1309 class_13092 = this.entity;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (!this.entity.method_37908().field_9236) {
                player.method_6092(new class_1293(class_1294.field_5919, 100, 0, false, false));
            }
        }
    }

    public void onBoneTreatmentApplied() {
        this.boneGraceTicksRemaining = Math.max(0, this.boneGraceTicksRemaining) + 320;
    }

    protected boolean isTorsoBroken() {
        BodyPart t = this.getPart(PlayerBodyParts.TORSO);
        return t != null && t.isBroken();
    }

    public boolean isDowned() {
        return this.downed;
    }

    public boolean isBeingRevived() {
        return this.beingRevived;
    }

    public void setDowned(boolean downed) {
        this.downed = downed;
    }

    public void setBeingRevived(boolean beingRevived) {
        this.beingRevived = beingRevived;
    }

    public int getBleedOutTicksRemaining() {
        return this.bleedOutTicksRemaining;
    }

    public void setBleedOutTicksRemaining(int ticks) {
        this.bleedOutTicksRemaining = ticks;
    }

    public boolean tryBeginRevive(class_1657 reviver) {
        if (!this.downed) {
            return false;
        }
        if (this.beingRevived) {
            return this.reviverUuid != null && this.reviverUuid.equals(reviver.method_5667());
        }
        this.beingRevived = true;
        this.reviverUuid = reviver.method_5667();
        return true;
    }

    public void endRevive(class_1657 reviver) {
        if (this.reviverUuid != null && this.reviverUuid.equals(reviver.method_5667())) {
            this.beingRevived = false;
            this.reviverUuid = null;
        }
    }

    public void startDowned() {
        if (this.downed) {
            return;
        }
        this.downed = true;
        this.bleedOutTicksRemaining = this.isTorsoBroken() ? 800 : 1600;
    }

    public void clearDowned() {
        this.downed = false;
        this.beingRevived = false;
        this.reviverUuid = null;
        this.bleedOutTicksRemaining = 0;
    }

    public boolean isPendingDeath() {
        return this.pendingDeath;
    }

    public void onVanillaDeath() {
        this.clearDowned();
        this.pendingDeath = false;
    }

    public void forceGiveUp() {
        if (this.entity == null || this.entity.method_37908().field_9236) {
            return;
        }
        if (!this.downed) {
            return;
        }
        this.pendingDeath = true;
        if (this.entity.method_5805()) {
            this.entity.method_5643(this.entity.method_48923().method_48829(), 1000.0f);
        }
    }

    public void tickDowned() {
        if (!this.downed) {
            return;
        }
        if (this.entity.method_37908().field_9236) {
            return;
        }
        if (!this.beingRevived) {
            if (this.bleedOutTicksRemaining > 0) {
                --this.bleedOutTicksRemaining;
            }
            if (this.bleedOutTicksRemaining <= 0) {
                if (this.entity.method_5805()) {
                    this.pendingDeath = true;
                    this.entity.method_5643(this.entity.method_48923().method_48829(), 1000.0f);
                }
                this.clearDowned();
            }
        }
    }

    public void applyRevival(int healPerPart, int bonesToFix) {
        if (!this.downed) {
            return;
        }
        for (BodyPart p : this.getParts()) {
            float boost = Math.max(0.0f, this.getBoostForPart(p.getIdentifier()));
            float effMax = p.getMaxHealth() + boost;
            if (!(p.getHealth() < effMax)) continue;
            p.setHealth(Math.min(effMax, p.getHealth() + (float)healPerPart));
        }
        this.fixBrokenBonesPreferTorso(bonesToFix);
        this.clearDowned();
        this.pendingDeath = false;
        this.updateHealth();
    }

    private void fixBrokenBonesPreferTorso(int count) {
        if (count <= 0) {
            return;
        }
        ArrayList<BodyPart> candidates = new ArrayList<BodyPart>();
        BodyPart torso = this.getPart(PlayerBodyParts.TORSO);
        if (torso != null && torso.isBroken()) {
            torso.setBroken(false);
            torso.setBrokenTopHalf(null);
            if (torso.getHealth() <= 0.0f) {
                torso.setHealth(1.0f);
            }
            --count;
        }
        if (count <= 0) {
            return;
        }
        for (BodyPart p : this.getParts()) {
            if (p.getIdentifier().equals((Object)PlayerBodyParts.HEAD) || !p.isBroken()) continue;
            candidates.add(p);
        }
        Collections.shuffle(candidates, new Random());
        for (BodyPart p : candidates) {
            if (count <= 0) break;
            p.setBroken(false);
            p.setBrokenTopHalf(null);
            if (p.getHealth() <= 0.0f) {
                p.setHealth(1.0f);
            }
            --count;
        }
    }

    protected boolean anyBoneBroken() {
        for (BodyPart p : this.getParts()) {
            if (p.getIdentifier().equals((Object)PlayerBodyParts.HEAD) || !p.isBroken()) continue;
            return true;
        }
        return false;
    }

    protected int brokenBonesCount() {
        int c = 0;
        for (BodyPart p : this.getParts()) {
            if (p.getIdentifier().equals((Object)PlayerBodyParts.HEAD) || !p.isBroken()) continue;
            ++c;
        }
        return c;
    }

    protected void ensureAbsorptionBucketsUpToDate() {
        this.buckets.ensureAbsorptionBucketsUpToDate();
    }

    protected void ensureBoostBucketsUpToDate() {
        this.buckets.ensureBoostBucketsUpToDate();
    }

    protected float getAbsorptionBucket(BodyPart part) {
        return this.buckets.bucketFor(part);
    }

    protected void consumeAbsorptionFromBucket(BodyPart part, float amount) {
        this.buckets.consumeAbsorption(part, amount);
    }

    protected float getBoostBucket(BodyPart part) {
        if (part == null) {
            return 0.0f;
        }
        return this.boostBuckets.getOrDefault(part.getIdentifier(), Float.valueOf(0.0f)).floatValue();
    }

    protected void consumeBoostFromBucket(BodyPart part, float amount) {
        if (part == null || amount <= 0.0f) {
            return;
        }
        class_2960 id = part.getIdentifier();
        float current = this.boostBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
        float newVal = Math.max(0.0f, current - amount);
        this.boostBuckets.put(id, Float.valueOf(newVal));
    }

    public void prepareBucketSync() {
        this.buckets.prepareBucketSync();
    }

    public void clientSetAbsorptionBucket(class_2960 id, float value) {
        this.buckets.clientSetAbsorptionBucket(id, value);
    }

    public void clientSetBoostBucket(class_2960 id, float value) {
        this.buckets.clientSetBoostBucket(id, value);
    }

    public float getAbsorptionForPart(class_2960 id) {
        return this.buckets.getAbsorptionForPart(id);
    }

    public float getBoostForPart(class_2960 id) {
        return this.buckets.getBoostForPart(id);
    }

    public boolean syncBoostIfNeeded() {
        return this.buckets.syncBoostIfNeeded();
    }
}

