/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.body;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_2960;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;

class BodyBuckets {
    private final Body body;
    private final HashMap<class_2960, Float> absorptionBuckets = new HashMap();
    private final HashMap<class_2960, Float> boostBuckets = new HashMap();
    private float lastKnownMaxHealth = -1.0f;

    BodyBuckets(Body body) {
        this.body = body;
    }

    void onPartAdded(class_2960 id) {
        this.absorptionBuckets.put(id, Float.valueOf(0.0f));
        this.boostBuckets.put(id, Float.valueOf(0.0f));
    }

    void ensureAbsorptionBucketsUpToDate() {
        float reclaim = 0.0f;
        for (BodyPart bodyPart : this.body.getParts()) {
            class_2960 id;
            float b;
            if (!(bodyPart.getHealth() <= 0.0f) || !((b = this.absorptionBuckets.getOrDefault(id = bodyPart.getIdentifier(), Float.valueOf(0.0f)).floatValue()) > 0.0f)) continue;
            reclaim += b;
            this.absorptionBuckets.put(id, Float.valueOf(0.0f));
        }
        if (reclaim > 0.0f) {
            this.addAbsorptionToBuckets(reclaim);
        }
        float totalBuckets = 0.0f;
        for (class_2960 id : this.absorptionBuckets.keySet()) {
            totalBuckets += this.absorptionBuckets.get(id).floatValue();
        }
        float f = this.body.entity.method_6067();
        if (f > totalBuckets + 0.001f) {
            this.addAbsorptionToBuckets(f - totalBuckets);
        } else if (f + 0.001f < totalBuckets) {
            float factor = f <= 0.0f ? 0.0f : f / Math.max(totalBuckets, 1.0E-4f);
            for (class_2960 id : new ArrayList<class_2960>(this.absorptionBuckets.keySet())) {
                this.absorptionBuckets.put(id, Float.valueOf(this.absorptionBuckets.get(id).floatValue() * factor));
            }
        }
    }

    private void addAbsorptionToBuckets(float amount) {
        float current;
        float add;
        if (amount <= 0.0f) {
            return;
        }
        class_2960 HEAD = PlayerBodyParts.HEAD;
        class_2960 TORSO = PlayerBodyParts.TORSO;
        BodyPart head = this.body.getPart(HEAD);
        BodyPart torso = this.body.getPart(TORSO);
        if (head != null && head.getHealth() > 0.0f && (add = Math.min(2.0f - (current = this.absorptionBuckets.getOrDefault(HEAD, Float.valueOf(0.0f)).floatValue()), amount)) > 0.0f) {
            this.absorptionBuckets.put(HEAD, Float.valueOf(current + add));
            amount -= add;
        }
        if (amount > 0.0f && torso != null && torso.getHealth() > 0.0f && (add = Math.min(2.0f - (current = this.absorptionBuckets.getOrDefault(TORSO, Float.valueOf(0.0f)).floatValue()), amount)) > 0.0f) {
            this.absorptionBuckets.put(TORSO, Float.valueOf(current + add));
            amount -= add;
        }
        ArrayList<BodyPart> alive = new ArrayList<BodyPart>();
        for (BodyPart p : this.body.getParts()) {
            if (!(p.getHealth() > 0.0f)) continue;
            alive.add(p);
        }
        if (amount > 0.0f && !alive.isEmpty()) {
            float share = amount / (float)alive.size();
            for (BodyPart p : alive) {
                class_2960 id = p.getIdentifier();
                float current2 = this.absorptionBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
                this.absorptionBuckets.put(id, Float.valueOf(current2 + share));
            }
        }
    }

    float getAbsorptionBucket(BodyPart part) {
        if (part == null) {
            return 0.0f;
        }
        return this.absorptionBuckets.getOrDefault(part.getIdentifier(), Float.valueOf(0.0f)).floatValue();
    }

    void consumeAbsorptionFromBucket(BodyPart part, float amount) {
        if (part == null || amount <= 0.0f) {
            return;
        }
        class_2960 id = part.getIdentifier();
        float current = this.absorptionBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
        this.absorptionBuckets.put(id, Float.valueOf(Math.max(0.0f, current - amount)));
    }

    void ensureBoostBucketsUpToDate() {
        float reclaim = 0.0f;
        for (BodyPart bodyPart : this.body.getParts()) {
            class_2960 id;
            float b;
            if (!(bodyPart.getHealth() <= 0.0f) || !((b = this.boostBuckets.getOrDefault(id = bodyPart.getIdentifier(), Float.valueOf(0.0f)).floatValue()) > 0.0f)) continue;
            reclaim += b;
            this.boostBuckets.put(id, Float.valueOf(0.0f));
        }
        if (reclaim > 0.0f) {
            this.addBoostToBuckets(reclaim);
        }
        float totalBuckets = 0.0f;
        for (class_2960 id : this.boostBuckets.keySet()) {
            totalBuckets += this.boostBuckets.get(id).floatValue();
        }
        float f = Math.max(0.0f, this.body.entity.method_6063() - 20.0f);
        if (f > totalBuckets + 0.001f) {
            this.addBoostToBuckets(f - totalBuckets);
        } else if (f + 0.001f < totalBuckets) {
            float factor = f <= 0.0f ? 0.0f : f / Math.max(totalBuckets, 1.0E-4f);
            for (class_2960 id : new ArrayList<class_2960>(this.boostBuckets.keySet())) {
                this.boostBuckets.put(id, Float.valueOf(this.boostBuckets.get(id).floatValue() * factor));
            }
        }
        this.clampAllPartsToEffectiveCap();
    }

    private void clampAllPartsToEffectiveCap() {
        for (BodyPart p : this.body.getParts()) {
            float boost = this.getBoostForPart(p.getIdentifier());
            float cap = p.getMaxHealth() + Math.max(0.0f, boost);
            if (!(p.getHealth() > cap)) continue;
            p.setHealth(cap);
        }
    }

    private void addBoostToBuckets(float amount) {
        float current;
        float add;
        if (amount <= 0.0f) {
            return;
        }
        class_2960 HEAD = PlayerBodyParts.HEAD;
        class_2960 TORSO = PlayerBodyParts.TORSO;
        BodyPart head = this.body.getPart(HEAD);
        BodyPart torso = this.body.getPart(TORSO);
        if (head != null && head.getHealth() > 0.0f && (add = Math.min(2.0f - (current = this.boostBuckets.getOrDefault(HEAD, Float.valueOf(0.0f)).floatValue()), amount)) > 0.0f) {
            this.boostBuckets.put(HEAD, Float.valueOf(current + add));
            amount -= add;
        }
        if (amount > 0.0f && torso != null && torso.getHealth() > 0.0f && (add = Math.min(2.0f - (current = this.boostBuckets.getOrDefault(TORSO, Float.valueOf(0.0f)).floatValue()), amount)) > 0.0f) {
            this.boostBuckets.put(TORSO, Float.valueOf(current + add));
            amount -= add;
        }
        ArrayList<BodyPart> alive = new ArrayList<BodyPart>();
        for (BodyPart p : this.body.getParts()) {
            if (!(p.getHealth() > 0.0f)) continue;
            alive.add(p);
        }
        if (amount > 0.0f && !alive.isEmpty()) {
            float share = amount / (float)alive.size();
            for (BodyPart p : alive) {
                class_2960 id = p.getIdentifier();
                float current2 = this.boostBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
                this.boostBuckets.put(id, Float.valueOf(current2 + share));
            }
        }
    }

    void prepareBucketSync() {
        this.ensureAbsorptionBucketsUpToDate();
        this.ensureBoostBucketsUpToDate();
    }

    void clientSetAbsorptionBucket(class_2960 id, float value) {
        this.absorptionBuckets.put(id, Float.valueOf(Math.max(0.0f, value)));
    }

    void clientSetBoostBucket(class_2960 id, float value) {
        this.boostBuckets.put(id, Float.valueOf(Math.max(0.0f, value)));
    }

    float getAbsorptionForPart(class_2960 id) {
        return this.absorptionBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    float getBoostForPart(class_2960 id) {
        return this.boostBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    boolean syncBoostIfNeeded() {
        float current;
        float f = current = this.body.entity != null ? this.body.entity.method_6063() : 0.0f;
        if (this.lastKnownMaxHealth < 0.0f) {
            this.lastKnownMaxHealth = current;
            this.ensureBoostBucketsUpToDate();
            this.clampAllPartsToEffectiveCap();
            return true;
        }
        if (Math.abs(current - this.lastKnownMaxHealth) > 0.01f) {
            this.lastKnownMaxHealth = current;
            this.ensureBoostBucketsUpToDate();
            this.clampAllPartsToEffectiveCap();
            this.body.updateHealth();
            return true;
        }
        return false;
    }

    float bucketFor(BodyPart part) {
        return this.getAbsorptionBucket(part);
    }

    void consumeAbsorption(BodyPart part, float amt) {
        this.consumeAbsorptionFromBucket(part, amt);
    }
}

