/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.body;

import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.player.BodyProvider;

public abstract class BodyPart {
    private float maxHealth;
    private float health;
    private boolean broken = false;
    private Boolean brokenTopHalf = null;
    private float sleepHealBonus = 0.0f;
    private int brokenTicks = 0;
    private boolean fractureLocked = false;
    private int smallWounds = 0;
    private int largeWounds = 0;
    private boolean tourniquet = false;
    private int tqOnTicks = 0;
    private int tqOffAccumulatedTicks = 0;
    private int tqOffStartTick = -1;
    private int tqClientTicks = 0;
    private int woundBleedTicks = 0;
    private int woundBleedTicksLarge = 0;
    private int necrosisState = 0;
    private int necrosisTicks = 0;
    private int recoveryTicks = 0;
    private float necrosisScale = 1.0f;
    private float procScale = 1.0f;
    private int procRecoveryTicks = 0;
    protected float criticalThreshold;
    private class_1309 entity;
    private class_2960 identifier;
    protected int armorSlot;
    protected Body body;
    protected boolean isKillRequirement = false;
    protected class_2371<class_1799> armorList;

    public BodyPart(float maxHealth, float health, class_1309 entity, class_2960 identifier) {
        this.maxHealth = maxHealth;
        this.health = health;
        this.entity = entity;
        this.identifier = identifier;
        this.body = ((BodyProvider)entity).getBody();
    }

    public void setHealth(float health) {
        float boost = 0.0f;
        try {
            if (this.body != null && this.identifier != null) {
                boost = Math.max(0.0f, this.body.getBoostForPart(this.identifier));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        float cap = this.getMaxHealth() + boost;
        this.health = Math.min(Math.max(health, 0.0f), cap);
        this.body.checkNoCritical(this);
    }

    public void heal() {
        float boost = 0.0f;
        try {
            if (this.body != null && this.identifier != null) {
                boost = Math.max(0.0f, this.body.getBoostForPart(this.identifier));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setHealth(this.getMaxHealth() + boost);
    }

    public float heal(float amount) {
        float newHealth = this.health + amount;
        this.setHealth(newHealth);
        return newHealth - this.health;
    }

    public void damage() {
        this.setHealth(0.0f);
    }

    public float damage(float amount) {
        float newHealth = this.health - amount;
        this.setHealth(newHealth);
        return Math.max(0.0f, -newHealth);
    }

    public float damageWithoutKill(float amount) {
        float newHealth = this.health - amount;
        if (this.isKillRequirement) {
            this.setHealth(Math.max(1.0f, newHealth));
        } else {
            this.setHealth(newHealth);
        }
        return Math.max(0.0f, -newHealth);
    }

    public class_1799 getAffectedArmor() {
        return (class_1799)this.armorList.get(this.armorSlot);
    }

    public int getArmorSlot() {
        return this.armorSlot;
    }

    public float getHealth() {
        return this.health;
    }

    public float getMaxHealth() {
        float scale = Math.max(0.0f, Math.min(1.0f, this.necrosisScale)) * Math.max(0.0f, Math.min(1.0f, this.procScale));
        return Math.max(0.0f, this.maxHealth * scale);
    }

    public float getBaseMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
        this.setHealth(Math.min(this.getHealth(), this.getMaxHealth()));
    }

    public class_1309 getEntity() {
        return this.entity;
    }

    public void setEntity(class_1309 entity) {
        this.entity = entity;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(class_2960 identifier) {
        this.identifier = identifier;
    }

    public float getCriticalThreshold() {
        return this.criticalThreshold;
    }

    public void writeToNbt(class_2487 nbt) {
        class_2487 new_nbt = new class_2487();
        new_nbt.method_10548("health", this.health);
        new_nbt.method_10556("broken", this.broken);
        if (this.brokenTopHalf != null) {
            new_nbt.method_10556("brokenTopHalf", this.brokenTopHalf.booleanValue());
        }
        if (this.sleepHealBonus > 0.0f) {
            new_nbt.method_10548("sleepHealBonus", this.sleepHealBonus);
        }
        if (this.broken && this.brokenTicks > 0) {
            new_nbt.method_10569("brokenTicks", this.brokenTicks);
        }
        if (this.fractureLocked) {
            new_nbt.method_10556("fractureLocked", true);
        }
        if (this.smallWounds > 0) {
            new_nbt.method_10569("smallWounds", this.smallWounds);
        }
        if (this.largeWounds > 0) {
            new_nbt.method_10569("largeWounds", this.largeWounds);
        }
        if (this.tourniquet) {
            new_nbt.method_10556("tourniquet", true);
        }
        if (this.tqOnTicks > 0) {
            new_nbt.method_10569("tqOnTicks", this.tqOnTicks);
        }
        if (this.tqOffAccumulatedTicks > 0) {
            new_nbt.method_10569("tqOffAccumulatedTicks", this.tqOffAccumulatedTicks);
        }
        if (this.necrosisState != 0) {
            new_nbt.method_10569("necrosisState", this.necrosisState);
        }
        if (this.necrosisTicks > 0) {
            new_nbt.method_10569("necrosisTicks", this.necrosisTicks);
        }
        if (this.recoveryTicks > 0) {
            new_nbt.method_10569("recoveryTicks", this.recoveryTicks);
        }
        if (this.necrosisScale != 1.0f) {
            new_nbt.method_10548("necrosisScale", this.necrosisScale);
        }
        if (this.woundBleedTicks > 0) {
            new_nbt.method_10569("woundBleedTicks", this.woundBleedTicks);
        }
        if (this.procScale != 1.0f) {
            new_nbt.method_10548("procScale", this.procScale);
        }
        if (this.procRecoveryTicks > 0) {
            new_nbt.method_10569("procRecoveryTicks", this.procRecoveryTicks);
        }
        nbt.method_10566(this.identifier.toString(), (class_2520)new_nbt);
    }

    public void readFromNbt(class_2487 nbt) {
        this.health = nbt.method_10583("health");
        this.broken = nbt.method_10545("broken") ? nbt.method_10577("broken") : false;
        this.brokenTopHalf = nbt.method_10545("brokenTopHalf") ? Boolean.valueOf(nbt.method_10577("brokenTopHalf")) : null;
        this.sleepHealBonus = nbt.method_10545("sleepHealBonus") ? nbt.method_10583("sleepHealBonus") : 0.0f;
        this.brokenTicks = this.broken && nbt.method_10545("brokenTicks") ? nbt.method_10550("brokenTicks") : 0;
        this.fractureLocked = nbt.method_10545("fractureLocked") ? nbt.method_10577("fractureLocked") : false;
        this.smallWounds = nbt.method_10545("smallWounds") ? nbt.method_10550("smallWounds") : 0;
        this.largeWounds = nbt.method_10545("largeWounds") ? nbt.method_10550("largeWounds") : 0;
        this.tourniquet = nbt.method_10545("tourniquet") && nbt.method_10577("tourniquet");
        this.tqOnTicks = nbt.method_10545("tqOnTicks") ? nbt.method_10550("tqOnTicks") : 0;
        this.tqOffAccumulatedTicks = nbt.method_10545("tqOffAccumulatedTicks") ? nbt.method_10550("tqOffAccumulatedTicks") : 0;
        this.tqOffStartTick = -1;
        this.necrosisState = nbt.method_10545("necrosisState") ? nbt.method_10550("necrosisState") : 0;
        this.necrosisTicks = nbt.method_10545("necrosisTicks") ? nbt.method_10550("necrosisTicks") : 0;
        this.recoveryTicks = nbt.method_10545("recoveryTicks") ? nbt.method_10550("recoveryTicks") : 0;
        this.necrosisScale = nbt.method_10545("necrosisScale") ? nbt.method_10583("necrosisScale") : 1.0f;
        this.woundBleedTicks = nbt.method_10545("woundBleedTicks") ? nbt.method_10550("woundBleedTicks") : 0;
        this.smallWounds = Math.max(0, Math.min(1, this.smallWounds));
        this.largeWounds = Math.max(0, Math.min(1, this.largeWounds));
        if (this.smallWounds + this.largeWounds > 1) {
            if (this.largeWounds > 0) {
                this.smallWounds = 0;
            } else {
                this.largeWounds = 0;
            }
        }
        this.necrosisScale = Math.max(0.0f, Math.min(1.0f, this.necrosisScale));
        this.procScale = nbt.method_10545("procScale") ? Math.max(0.0f, Math.min(1.0f, nbt.method_10583("procScale"))) : 1.0f;
        this.procRecoveryTicks = nbt.method_10545("procRecoveryTicks") ? Math.max(0, nbt.method_10550("procRecoveryTicks")) : 0;
    }

    public String toString() {
        return this.identifier.method_12832() + " | MaxHP: " + this.getMaxHealth() + " | HP " + this.health + "\n";
    }

    public boolean isDamaged() {
        float boost = 0.0f;
        try {
            if (this.body != null && this.identifier != null) {
                boost = Math.max(0.0f, this.body.getBoostForPart(this.identifier));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.health < this.getMaxHealth() + boost;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
        if (!broken) {
            this.sleepHealBonus = 0.0f;
            this.brokenTicks = 0;
            this.fractureLocked = false;
        } else {
            this.brokenTicks = 0;
        }
    }

    public Boolean getBrokenTopHalf() {
        return this.brokenTopHalf;
    }

    public void setBrokenTopHalf(Boolean brokenTopHalf) {
        this.brokenTopHalf = brokenTopHalf;
    }

    public float getSleepHealBonus() {
        return this.sleepHealBonus;
    }

    public int getBrokenTicks() {
        return this.brokenTicks;
    }

    public void tickBroken() {
        if (this.broken && this.brokenTicks < Integer.MAX_VALUE) {
            ++this.brokenTicks;
        }
    }

    public boolean isFractureLocked() {
        return this.fractureLocked;
    }

    public void setFractureLocked(boolean locked) {
        this.fractureLocked = locked;
    }

    public void setSleepHealBonus(float bonus) {
        this.sleepHealBonus = Math.max(0.0f, Math.min(1.0f, bonus));
    }

    public int getSmallWounds() {
        return this.smallWounds;
    }

    public int getLargeWounds() {
        return this.largeWounds;
    }

    public int getTotalWounds() {
        return this.smallWounds + this.largeWounds;
    }

    public boolean hasWoundCapacity() {
        return this.getTotalWounds() < 1;
    }

    public boolean addSmallWound() {
        if (this.largeWounds > 0) {
            return false;
        }
        if (this.smallWounds > 0) {
            return false;
        }
        this.smallWounds = 1;
        this.woundBleedTicks = 0;
        return true;
    }

    public boolean addLargeWound() {
        if (this.largeWounds > 0) {
            return false;
        }
        if (this.smallWounds > 0) {
            this.smallWounds = 0;
        }
        this.largeWounds = 1;
        this.woundBleedTicks = 0;
        return true;
    }

    public boolean removeSmallWound() {
        if (this.smallWounds <= 0) {
            return false;
        }
        this.smallWounds = 0;
        this.woundBleedTicks = 0;
        return true;
    }

    public boolean removeLargeWound() {
        if (this.largeWounds <= 0) {
            return false;
        }
        this.largeWounds = 0;
        this.woundBleedTicks = 0;
        return true;
    }

    public boolean hasTourniquet() {
        return this.tourniquet;
    }

    public int getTourniquetTicks() {
        try {
            if (this.entity != null && this.entity.method_37908() != null && this.entity.method_37908().field_9236) {
                return Math.max(0, this.tqClientTicks);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int eff = this.tqOnTicks - this.tqOffAccumulatedTicks;
        if (eff < 0) {
            eff = 0;
        }
        return eff;
    }

    public void setTourniquet(boolean applied) {
        if (this.tourniquet == applied) {
            return;
        }
        this.tourniquet = applied;
        if (applied) {
            if (this.tqOffStartTick >= 0 && this.entity != null) {
                int off = Math.max(0, this.entity.field_6012 - this.tqOffStartTick);
                this.tqOffAccumulatedTicks = Math.min(Integer.MAX_VALUE, this.tqOffAccumulatedTicks + off);
            }
            this.tqOffStartTick = -1;
        } else {
            int n = this.tqOffStartTick = this.entity != null ? this.entity.field_6012 : -1;
            if (this.necrosisState == 1) {
                this.recoveryTicks = 6000;
            }
        }
    }

    public void tickTourniquet() {
        if (this.tourniquet && this.tqOnTicks < Integer.MAX_VALUE) {
            ++this.tqOnTicks;
        }
    }

    public void tickWoundBleed() {
        if (this.getTotalWounds() > 0 && this.woundBleedTicks < Integer.MAX_VALUE) {
            ++this.woundBleedTicks;
        }
    }

    public int getWoundBleedTicks() {
        return this.woundBleedTicks;
    }

    public void resetWoundBleedTicks() {
        this.woundBleedTicks = 0;
    }

    public void tickWoundBleedLarge() {
        if (this.getLargeWounds() > 0 && this.woundBleedTicksLarge < Integer.MAX_VALUE) {
            ++this.woundBleedTicksLarge;
        }
    }

    public int getWoundBleedTicksLarge() {
        return this.woundBleedTicksLarge;
    }

    public void resetWoundBleedTicksLarge() {
        this.woundBleedTicksLarge = 0;
    }

    public int getNecrosisState() {
        return this.necrosisState;
    }

    public float getNecrosisScale() {
        return this.necrosisScale;
    }

    public void setPermaDead() {
        this.necrosisState = 2;
        this.necrosisTicks = 0;
        this.recoveryTicks = 0;
        this.necrosisScale = 0.0f;
        this.setHealth(0.0f);
    }

    public void beginNecrosis() {
        if (this.necrosisState == 0) {
            this.necrosisState = 1;
            this.necrosisTicks = 0;
        }
    }

    public void clearNecrosis() {
        this.necrosisState = 0;
        this.necrosisTicks = 0;
    }

    public void tickNecrosisLinear(float totalMinutes) {
        if (this.necrosisState != 1) {
            return;
        }
        ++this.necrosisTicks;
        int totalTicks = Math.max(1, (int)(totalMinutes * 60.0f * 20.0f));
        float progress = Math.min(1.0f, (float)this.necrosisTicks / (float)totalTicks);
        this.necrosisScale = Math.max(0.0f, 1.0f - progress);
        if (this.health > this.getMaxHealth()) {
            this.setHealth(this.getMaxHealth());
        }
        if (progress >= 1.0f) {
            // empty if block
        }
    }

    public void tickRecovery() {
        if (this.recoveryTicks > 0) {
            --this.recoveryTicks;
            float step = 1.6666666E-4f;
            this.necrosisScale = Math.min(1.0f, this.necrosisScale + step);
        }
    }

    public void forceStartRecovery() {
        this.recoveryTicks = 6000;
    }

    public void beginStitchDebuff() {
        this.procScale = 0.5f;
        this.procRecoveryTicks = 3600;
        if (this.health > this.getMaxHealth()) {
            this.setHealth(this.getMaxHealth());
        }
    }

    public void tickProcedureRecovery() {
        if (this.procRecoveryTicks > 0) {
            --this.procRecoveryTicks;
            float step = 1.3888889E-4f;
            this.procScale = Math.min(1.0f, this.procScale + step);
        }
    }

    public boolean hasProcedureDebuff() {
        return this.procRecoveryTicks > 0 || this.procScale < 1.0f;
    }

    public void clearProcedureDebuff() {
        this.procScale = 1.0f;
        this.procRecoveryTicks = 0;
    }

    public void clientSetWounds(int small, int large) {
        this.smallWounds = Math.max(0, Math.min(1, small));
        this.largeWounds = Math.max(0, Math.min(1, large));
        if (this.smallWounds + this.largeWounds > 1) {
            if (this.largeWounds > 0) {
                this.smallWounds = 0;
            } else {
                this.largeWounds = 0;
            }
        }
    }

    public void clientSetTourniquet(boolean applied, int ticks) {
        this.tourniquet = applied;
        this.tqClientTicks = Math.max(0, ticks);
    }

    public void clientSetNecrosis(int state, float scale) {
        this.necrosisState = Math.max(0, Math.min(2, state));
        this.necrosisScale = Math.max(0.0f, Math.min(1.0f, scale));
        if (this.health > this.getMaxHealth()) {
            this.setHealth(this.getMaxHealth());
        }
    }
}

