/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.body.player;

import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1738;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.BodySide;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.body.player.parts.ArmBodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.parts.FootBodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.parts.HeadBodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.parts.LegBodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.parts.TorsoBodyPart;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.util.ProjectileHitTracker;
import xyz.srgnis.bodyhealthsystem.util.Utils;

public class PlayerBody
extends Body {
    public PlayerBody(class_1657 player) {
        this.entity = player;
    }

    @Override
    public void initParts() {
        class_1657 player = (class_1657)this.entity;
        this.addPart(PlayerBodyParts.HEAD, new HeadBodyPart(player));
        this.addPart(PlayerBodyParts.TORSO, new TorsoBodyPart(player));
        this.addPart(PlayerBodyParts.LEFT_ARM, new ArmBodyPart(BodySide.LEFT, player));
        this.addPart(PlayerBodyParts.RIGHT_ARM, new ArmBodyPart(BodySide.RIGHT, player));
        this.addPart(PlayerBodyParts.LEFT_FOOT, new FootBodyPart(BodySide.LEFT, player));
        this.addPart(PlayerBodyParts.RIGHT_FOOT, new FootBodyPart(BodySide.RIGHT, player));
        this.addPart(PlayerBodyParts.LEFT_LEG, new LegBodyPart(BodySide.LEFT, player));
        this.addPart(PlayerBodyParts.RIGHT_LEG, new LegBodyPart(BodySide.RIGHT, player));
        this.noCriticalParts.putAll(this.parts);
    }

    @Override
    public void applyDamageBySource(float amount, class_1282 source) {
        if (source == null) {
            super.applyDamageBySource(amount, source);
            return;
        }
        if (source.method_49708(class_8111.field_42345) || source.method_49708(class_8111.field_42339)) {
            this.applyFallDamage(amount, source);
        } else if (source.method_49708(class_8111.field_42336) || source.method_49708(class_8111.field_42338) || source.method_49708(class_8111.field_42325) || source.method_49708(class_8111.field_42331) || source.method_49708(class_8111.field_42332)) {
            this.applyDamageFullRandom(amount, source);
        } else if (source.method_49708(class_8111.field_42343)) {
            this.applyDamageLocal(amount, source, this.getPart(PlayerBodyParts.TORSO));
        } else if (source.method_49708(class_8111.field_42342)) {
            this.applyDamageLocal(Config.drowningDamage, source, this.getPart(PlayerBodyParts.TORSO));
        } else if (source.method_49708(class_8111.field_42346) || source.method_49708(class_8111.field_42357) || source.method_49708(class_8111.field_42356) || source.method_49708(class_8111.field_42358)) {
            this.applyDamageLocal(amount, source, this.getPart(PlayerBodyParts.HEAD));
        } else if (source.method_49708(class_8111.field_42321) || source.method_49708(class_8111.field_42323) || source.method_49708(class_8111.field_42322) || source.method_5526() instanceof class_1665) {
            class_243 norm = ProjectileHitTracker.getLastHit((class_1657)this.entity);
            BodyPart part = this.selectPartFromNormalized(norm);
            if (part != null) {
                BodyPart torso;
                if (part.getIdentifier().equals((Object)PlayerBodyParts.HEAD) && (torso = this.getPart(PlayerBodyParts.TORSO)) != null && this.entity.method_6051().method_43058() < 0.4) {
                    part = torso;
                }
                this.applyDamageLocal(amount, source, part);
                if (!this.entity.method_37908().field_9236 && Config.enableWoundingSystem) {
                    this.applyWoundChances(part, true);
                }
            } else {
                BodyPart p = this.getNoCriticalParts().get(this.entity.method_6051().method_43048(this.getNoCriticalParts().size()));
                this.applyDamageLocal(amount, source, p);
                if (!this.entity.method_37908().field_9236 && Config.enableWoundingSystem) {
                    this.applyWoundChances(p, true);
                }
            }
            ProjectileHitTracker.clear((class_1657)this.entity);
        } else {
            BodyPart p = this.getNoCriticalParts().get(this.entity.method_6051().method_43048(this.getNoCriticalParts().size()));
            this.applyDamageLocal(amount, source, p);
            if (!this.entity.method_37908().field_9236 && Config.enableWoundingSystem) {
                this.applyWoundChances(p, false);
            }
        }
    }

    public void applyFallDamage(float amount, class_1282 source) {
        float remaining = this.takeDamage(amount /= 2.0f, source, this.getPart(PlayerBodyParts.RIGHT_FOOT));
        if (remaining > 0.0f) {
            remaining = this.takeDamage(remaining, source, this.getPart(PlayerBodyParts.RIGHT_LEG));
        }
        if (remaining > 0.0f) {
            this.takeDamage(remaining, source, this.getPart(PlayerBodyParts.TORSO));
        }
        if ((remaining = this.takeDamage(amount, source, this.getPart(PlayerBodyParts.LEFT_FOOT))) > 0.0f) {
            remaining = this.takeDamage(remaining, source, this.getPart(PlayerBodyParts.LEFT_LEG));
        }
        if (remaining > 0.0f) {
            this.takeDamage(remaining, source, this.getPart(PlayerBodyParts.TORSO));
        }
    }

    public boolean isCrawlingRequired() {
        BodyPart leftLeg = this.getPart(PlayerBodyParts.LEFT_LEG);
        BodyPart rightLeg = this.getPart(PlayerBodyParts.RIGHT_LEG);
        BodyPart leftFoot = this.getPart(PlayerBodyParts.LEFT_FOOT);
        BodyPart rightFoot = this.getPart(PlayerBodyParts.RIGHT_FOOT);
        boolean bothLegsBroken = leftLeg != null && rightLeg != null && leftLeg.isBroken() && rightLeg.isBroken();
        boolean bothFeetBroken = leftFoot != null && rightFoot != null && leftFoot.isBroken() && rightFoot.isBroken();
        return bothLegsBroken && bothFeetBroken;
    }

    @Override
    public float takeDamage(float amount, class_1282 source, BodyPart part) {
        amount = this.applyArmorToDamage(source, amount, part);
        return super.takeDamage(amount, source, part);
    }

    @Override
    public float applyArmorToDamage(class_1282 source, float amount, BodyPart part) {
        if (part.getAffectedArmor().method_7909() instanceof class_1738 && !source.method_48789(class_8103.field_42241)) {
            class_1657 player = (class_1657)this.entity;
            class_1738 armorItem = (class_1738)part.getAffectedArmor().method_7909();
            player.method_31548().method_7375(source, amount, new int[]{part.getArmorSlot()});
            amount = class_1280.method_5496((float)amount, (float)Utils.modifyProtection(armorItem, part.getArmorSlot()), (float)Utils.modifyToughness(armorItem, part.getArmorSlot()));
        }
        return amount;
    }

    private void applyWoundChances(BodyPart part, boolean projectile) {
        if (!Config.enableWoundingSystem) {
            return;
        }
        if (this.suppressWoundEvaluation || part == null) {
            return;
        }
        if (this.entity.method_37908().field_9236) {
            return;
        }
        double multiplier = 1.0;
        class_2960 id = part.getIdentifier();
        if (id.equals((Object)PlayerBodyParts.LEFT_FOOT) || id.equals((Object)PlayerBodyParts.RIGHT_FOOT)) {
            multiplier = 0.75;
        }
        float hp = Math.max(0.0f, part.getHealth());
        float nearDeadHP = 1.0f;
        float max = Math.max(nearDeadHP, part.getMaxHealth());
        float denom = Math.max(1.0E-4f, max - nearDeadHP);
        float norm = Math.max(0.0f, Math.min(1.0f, (hp - nearDeadHP) / denom));
        float t = 1.0f - norm;
        double pSmall = (0.1 + 0.5 * (double)t) * multiplier;
        double pUpgradeToLarge = (0.05 + 0.35 * (double)t) * multiplier;
        pSmall = Math.max(0.0, Math.min(1.0, pSmall));
        pUpgradeToLarge = Math.max(0.0, Math.min(1.0, pUpgradeToLarge));
        class_5819 rnd = this.entity.method_6051();
        if (part.hasWoundCapacity() && rnd.method_43058() < pSmall && part.addSmallWound() && (part.hasWoundCapacity() || part.getSmallWounds() > 0) && rnd.method_43058() < pUpgradeToLarge) {
            part.addLargeWound();
        }
    }

    private BodyPart selectPartFromNormalized(class_243 norm) {
        if (norm == null) {
            return null;
        }
        double x = norm.field_1352;
        double y = norm.field_1351;
        if (y < 0.18) {
            return this.getPart(x >= 0.0 ? PlayerBodyParts.LEFT_FOOT : PlayerBodyParts.RIGHT_FOOT);
        }
        if (y < 0.5) {
            return this.getPart(x >= 0.0 ? PlayerBodyParts.LEFT_LEG : PlayerBodyParts.RIGHT_LEG);
        }
        if (y < 0.88) {
            if (y >= 0.6 && Math.abs(x) > 0.8) {
                return this.getPart(x >= 0.0 ? PlayerBodyParts.LEFT_ARM : PlayerBodyParts.RIGHT_ARM);
            }
            return this.getPart(PlayerBodyParts.TORSO);
        }
        return this.getPart(PlayerBodyParts.HEAD);
    }
}

