/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.items;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.BodyProvider;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.network.ServerNetworking;
import xyz.srgnis.bodyhealthsystem.registry.ModStatusEffects;

public class PlasterItem
extends class_1792 {
    private static final String TARGET_NBT = "PlasterTargetId";
    private static final int USE_TICKS = 40;
    private static final float HEAL_AMOUNT = 2.0f;

    public PlasterItem(class_1792.class_1793 settings) {
        super(settings);
    }

    private BodyPart findBestPlasterTarget(Body body) {
        Object best = null;
        BodyPart bestBroken = null;
        float brokenMissing = 0.0f;
        for (BodyPart part : body.getParts()) {
            float health = part.getHealth();
            float baseMax = part.getMaxHealth();
            float boost = Math.max(0.0f, body.getBoostForPart(part.getIdentifier()));
            float effMax = baseMax + boost;
            if (!(health <= 0.0f) || part.isFractureLocked()) continue;
            float missing = effMax - health;
            if (bestBroken != null && !(missing > brokenMissing)) continue;
            bestBroken = part;
            brokenMissing = missing;
        }
        if (bestBroken != null) {
            return bestBroken;
        }
        BodyPart bestTorsoHead = null;
        int bestTHPriority = -1;
        float bestTHMissing = 0.0f;
        for (BodyPart part : body.getParts()) {
            float boost;
            float baseMax;
            float effMax;
            float health;
            if (!part.getIdentifier().equals((Object)PlayerBodyParts.HEAD) && !part.getIdentifier().equals((Object)PlayerBodyParts.TORSO) || part.isFractureLocked() || (health = part.getHealth()) >= (effMax = (baseMax = part.getMaxHealth()) + (boost = Math.max(0.0f, body.getBoostForPart(part.getIdentifier()))))) continue;
            int priority = health <= part.getCriticalThreshold() ? 1 : 0;
            float missing = effMax - health;
            if (priority <= bestTHPriority && (priority != bestTHPriority || !(missing > bestTHMissing))) continue;
            bestTorsoHead = part;
            bestTHPriority = priority;
            bestTHMissing = missing;
        }
        if (bestTorsoHead != null) {
            return bestTorsoHead;
        }
        BodyPart bestGeneral = null;
        int bestPriority = -1;
        float bestMissing = 0.0f;
        for (BodyPart part : body.getParts()) {
            float boost;
            float baseMax;
            float effMax;
            float health;
            if (part.isFractureLocked() || (health = part.getHealth()) >= (effMax = (baseMax = part.getMaxHealth()) + (boost = Math.max(0.0f, body.getBoostForPart(part.getIdentifier()))))) continue;
            int priority = health <= part.getCriticalThreshold() ? 1 : 0;
            float missing = effMax - health;
            if (priority <= bestPriority && (priority != bestPriority || !(missing > bestMissing))) continue;
            bestGeneral = part;
            bestPriority = priority;
            bestMissing = missing;
        }
        return bestGeneral;
    }

    private boolean canUseOnTarget(class_1309 target) {
        if (target instanceof BodyProvider) {
            Body body = ((BodyProvider)target).getBody();
            BodyPart candidate = this.findBestPlasterTarget(body);
            return candidate != null;
        }
        return target.method_6032() < target.method_6063();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545(TARGET_NBT)) {
            tag.method_10551(TARGET_NBT);
            if (tag.method_33133()) {
                stack.method_7980(null);
            }
        }
        if (!this.canUseOnTarget((class_1309)user)) {
            return class_1271.method_22431((Object)stack);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)stack);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (!this.canUseOnTarget(entity)) {
            return class_1269.field_5811;
        }
        class_2487 tag = stack.method_7948();
        tag.method_10569(TARGET_NBT, entity.method_5628());
        user.method_6019(hand);
        return class_1269.field_21466;
    }

    public int method_7881(class_1799 stack) {
        return 40;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_42717;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.field_9236) {
            class_1309 target = user;
            class_2487 tag = stack.method_7969();
            if (tag != null && tag.method_10545(TARGET_NBT)) {
                class_1297 e = world.method_8469(tag.method_10550(TARGET_NBT));
                if (e instanceof class_1309) {
                    target = (class_1309)e;
                }
                tag.method_10551(TARGET_NBT);
                if (tag.method_33133()) {
                    stack.method_7980(null);
                }
            }
            boolean consumed = false;
            if (target instanceof BodyProvider) {
                BodyPart best;
                Body body = ((BodyProvider)target).getBody();
                BodyPart smallWoundPart = null;
                for (BodyPart p : body.getParts()) {
                    try {
                        if (p.getSmallWounds() <= 0) continue;
                        smallWoundPart = p;
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
                if (smallWoundPart != null && smallWoundPart.removeSmallWound()) {
                    consumed = true;
                }
                if ((best = this.findBestPlasterTarget(body)) != null) {
                    float healed;
                    float healValue = 2.0f;
                    if (target.method_6059(ModStatusEffects.DRESSING_EFFECT)) {
                        healValue *= 2.0f;
                        target.method_6016(ModStatusEffects.DRESSING_EFFECT);
                    }
                    float before = best.getHealth();
                    body.healPart(healValue, best);
                    body.updateHealth();
                    if (target instanceof class_1657) {
                        ServerNetworking.syncBody((class_1657)target);
                    }
                    if ((healed = best.getHealth() - before) > 0.0f) {
                        consumed = true;
                    }
                }
                if (consumed) {
                    stack.method_7934(1);
                    world.method_8396(null, target.method_24515(), class_3417.field_15226, class_3419.field_15248, 1.0f, 1.0f);
                }
            }
            if (!consumed && !(target instanceof BodyProvider) && target.method_6032() < target.method_6063()) {
                float healValue = 2.0f;
                if (target.method_6059(ModStatusEffects.DRESSING_EFFECT)) {
                    healValue *= 2.0f;
                    target.method_6016(ModStatusEffects.DRESSING_EFFECT);
                }
                target.method_5783(class_3417.field_14983, 1.0f, 1.0f);
                target.method_6025(healValue);
                stack.method_7934(1);
            }
        }
        return stack;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545(TARGET_NBT)) {
            tag.method_10551(TARGET_NBT);
            if (tag.method_33133()) {
                stack.method_7980(null);
            }
        }
    }
}

