/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.mixin;

import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.BodyProvider;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.network.ServerNetworking;

@Mixin(value={class_1657.class})
public abstract class SleepHealMixin {
    @Inject(method={"wakeUp"}, at={@At(value="TAIL")})
    private void bhs$onWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        class_1657 self = (class_1657)this;
        if (self.method_37908().method_8608()) {
            return;
        }
        if (!(self instanceof class_3222)) {
            return;
        }
        class_3222 spe = (class_3222)self;
        Body body = ((BodyProvider)self).getBody();
        if (body == null) {
            return;
        }
        float healPercent = Math.max(0.0f, Config.sleepHealPercent);
        if (healPercent > 0.0f) {
            float totalMax = 0.0f;
            for (BodyPart p : body.getParts()) {
                float boost = Math.max(0.0f, body.getBoostForPart(p.getIdentifier()));
                totalMax += p.getMaxHealth() + boost;
            }
            float toHeal = Math.max(0.0f, totalMax * healPercent);
            if (toHeal > 0.0f) {
                body.heal(toHeal);
                body.updateHealth();
            }
        }
        if (Config.enableBoneSystem) {
            float base = Math.max(0.0f, Config.sleepBoneHealBaseChance);
            float daily = Math.max(0.0f, Config.sleepBoneHealDailyIncrease);
            class_5819 rng = self.method_6051();
            ArrayList<BodyPart> broken = new ArrayList<BodyPart>();
            for (BodyPart p : body.getParts()) {
                if (p.getIdentifier().equals((Object)PlayerBodyParts.HEAD) || !p.isBroken()) continue;
                broken.add(p);
            }
            if (!broken.isEmpty()) {
                boolean healed;
                for (BodyPart p : broken) {
                    p.setSleepHealBonus(Math.min(1.0f, p.getSleepHealBonus() + daily));
                }
                BodyPart pick = (BodyPart)broken.get(rng.method_43048(broken.size()));
                float chance = Math.min(1.0f, base + pick.getSleepHealBonus());
                boolean bl = healed = rng.method_43057() < chance;
                if (healed) {
                    pick.setBroken(false);
                    pick.setBrokenTopHalf(null);
                    if (pick.getHealth() <= 0.0f) {
                        pick.setHealth(1.0f);
                    }
                    pick.setSleepHealBonus(0.0f);
                }
            }
        }
        for (BodyPart p : body.getParts()) {
            try {
                p.getClass().getMethod("clearProcedureDebuff", new Class[0]).invoke((Object)p, new Object[0]);
                int state = (Integer)p.getClass().getMethod("getNecrosisState", new Class[0]).invoke((Object)p, new Object[0]);
                if (state != 1) continue;
                p.getClass().getMethod("clearNecrosis", new Class[0]).invoke((Object)p, new Object[0]);
                p.getClass().getMethod("forceStartRecovery", new Class[0]).invoke((Object)p, new Object[0]);
                p.getClass().getMethod("clientSetNecrosis", Integer.TYPE, Float.TYPE).invoke((Object)p, 0, Float.valueOf(1.0f));
            }
            catch (Throwable throwable) {}
        }
        ServerNetworking.broadcastBody((class_1297)spe);
    }
}

