/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem;

import gavinx.temperatureapi.api.BlockThermalAPI;
import gavinx.temperatureapi.api.TemperatureAPI;
import gavinx.temperatureapi.api.TemperatureResistanceAPI;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.srgnis.bodyhealthsystem.block.AirConditionerBlock;
import xyz.srgnis.bodyhealthsystem.block.SpaceHeaterBlock;
import xyz.srgnis.bodyhealthsystem.command.DevCommands;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.items.StrawHatItem;
import xyz.srgnis.bodyhealthsystem.items.WoolClothingItem;
import xyz.srgnis.bodyhealthsystem.network.ServerNetworking;
import xyz.srgnis.bodyhealthsystem.registry.ModBlocks;
import xyz.srgnis.bodyhealthsystem.registry.ModItems;
import xyz.srgnis.bodyhealthsystem.registry.ModStatusEffects;
import xyz.srgnis.bodyhealthsystem.registry.ScreenHandlers;

public class BHSMain
implements ModInitializer {
    public static final String MOD_ID = "bodyhealthsystem";
    public static class_2960 MOD_IDENTIFIER = new class_2960("bodyhealthsystem");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"bodyhealthsystem");
    public static final class_5321<class_1761> BHS_GROUP = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)new class_2960("bodyhealthsystem", "general"));

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public void onInitialize() {
        class_2378.method_39197((class_2378)class_7923.field_44687, BHS_GROUP, (Object)FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)ModItems.PLASTER_ITEM)).method_47321((class_2561)class_2561.method_43471((String)"bodyhealthsystem.group.general")).method_47324());
        ServerNetworking.initialize();
        DevCommands.initialize();
        ModItems.registerItems();
        ModBlocks.registerBlocks();
        ModStatusEffects.registerStatusEffects();
        Config.init(MOD_ID, Config.class);
        BlockThermalAPI.register((world, pos, state) -> {
            if (!state.method_27852(class_2246.field_17350)) {
                return null;
            }
            if (!state.method_28498((class_2769)class_2741.field_12548) || !((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                return null;
            }
            return new BlockThermalAPI.ThermalSource(5.0, 5, BlockThermalAPI.OcclusionMode.FLOOD_FILL, 7, BlockThermalAPI.FalloffCurve.COSINE);
        }, (int)5);
        TemperatureResistanceAPI.registerProvider(player -> {
            if (player == null) {
                return null;
            }
            double heat = 0.0;
            double cold = 0.0;
            class_1799 head = player.method_6118(class_1304.field_6169);
            class_1799 chest = player.method_6118(class_1304.field_6174);
            class_1799 legs = player.method_6118(class_1304.field_6172);
            class_1799 feet = player.method_6118(class_1304.field_6166);
            if (!head.method_7960() && head.method_7909() instanceof StrawHatItem) {
                heat += TemperatureResistanceAPI.tierToDegrees((int)3);
            }
            for (class_1799 stack : new class_1799[]{head, chest, legs, feet}) {
                class_1738 armor;
                if (stack == null || stack.method_7960()) continue;
                if (stack.method_7909() instanceof WoolClothingItem) {
                    cold += TemperatureResistanceAPI.tierToDegrees((int)-3);
                    continue;
                }
                class_1792 patt4114$temp = stack.method_7909();
                if (!(patt4114$temp instanceof class_1738) || (armor = (class_1738)patt4114$temp).method_7686() != class_1740.field_7897) continue;
                cold += TemperatureResistanceAPI.tierToDegrees((int)-2);
            }
            if (heat == 0.0 && cold == 0.0) {
                return null;
            }
            return new TemperatureResistanceAPI.Resistance(heat, cold);
        });
        TemperatureResistanceAPI.registerProvider(player -> {
            if (player == null) {
                return null;
            }
            if (player.method_6059(class_1294.field_5918)) {
                return new TemperatureResistanceAPI.Resistance(TemperatureResistanceAPI.tierToDegrees((int)6), 0.0);
            }
            return null;
        });
        TemperatureResistanceAPI.registerProvider(player -> {
            boolean hasFan;
            if (player == null) {
                return null;
            }
            class_1799 main = player.method_6047();
            class_1799 off = player.method_6079();
            boolean bl = hasFan = !main.method_7960() && main.method_31574(ModItems.PORTABLE_FAN) || !off.method_7960() && off.method_31574(ModItems.PORTABLE_FAN);
            if (!hasFan) {
                return null;
            }
            return new TemperatureResistanceAPI.Resistance(TemperatureResistanceAPI.tierToDegrees((int)4), 0.0);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (Config.forceDisableVanillaRegen) {
                ((class_1928.class_4310)server.method_3767().method_20746(class_1928.field_19395)).method_20758(false, server);
                LOGGER.info("[{}] Disabled natural regeneration gamerule due to config", (Object)MOD_ID);
            }
        });
        ScreenHandlers.registerScreenHandlers();
        BlockThermalAPI.register((world, pos, state) -> {
            double deltaC;
            if (!state.method_27852(ModBlocks.AIR_CONDITIONER)) {
                return null;
            }
            if (!state.method_28498((class_2769)class_2741.field_12548) || !((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                return null;
            }
            boolean regulate = state.method_28498((class_2769)AirConditionerBlock.REGULATE) && (Boolean)state.method_11654((class_2769)AirConditionerBlock.REGULATE) != false;
            class_2350 face = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            if (regulate) {
                double env = TemperatureAPI.getEnvironmentCelsius((class_1937)world, (class_2338)pos);
                if (Double.isNaN(env)) {
                    return null;
                }
                double error = 22.0 - env;
                if (Math.abs(error) <= 0.25) {
                    return null;
                }
                if (error >= 0.0) {
                    return null;
                }
                deltaC = error;
            } else {
                deltaC = -6.0;
            }
            boolean outside = BlockThermalAPI.isOutside((class_1937)world, (class_2338)pos, (class_2350)face);
            int range = outside ? 4 : 7;
            int dropoff = outside ? 4 : 7;
            return new BlockThermalAPI.ThermalSource(deltaC, range, BlockThermalAPI.OcclusionMode.FLOOD_FILL, dropoff, BlockThermalAPI.FalloffCurve.COSINE, face);
        }, (int)15);
        BlockThermalAPI.register((world, pos, state) -> {
            double deltaC;
            if (!state.method_27852(ModBlocks.SPACE_HEATER)) {
                return null;
            }
            if (!state.method_28498((class_2769)class_2741.field_12548) || !((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                return null;
            }
            boolean regulate = state.method_28498((class_2769)SpaceHeaterBlock.REGULATE) && (Boolean)state.method_11654((class_2769)SpaceHeaterBlock.REGULATE) != false;
            class_2350 face = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            if (regulate) {
                double env = TemperatureAPI.getEnvironmentCelsius((class_1937)world, (class_2338)pos);
                if (Double.isNaN(env)) {
                    return null;
                }
                double error = 22.0 - env;
                if (Math.abs(error) <= 0.25) {
                    return null;
                }
                if (error <= 0.0) {
                    return null;
                }
                deltaC = error;
            } else {
                deltaC = 6.0;
            }
            boolean outside = BlockThermalAPI.isOutside((class_1937)world, (class_2338)pos, (class_2350)face);
            int range = outside ? 4 : 7;
            int dropoff = outside ? 4 : 7;
            return new BlockThermalAPI.ThermalSource(deltaC, range, BlockThermalAPI.OcclusionMode.FLOOD_FILL, dropoff, BlockThermalAPI.FalloffCurve.COSINE, face);
        }, (int)15);
    }

    public static boolean debuggerReleaseControl() {
        GLFW.glfwSetInputMode((long)class_310.method_1551().method_22683().method_4490(), (int)208897, (int)212993);
        return true;
    }
}

