/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.client.screen;

import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.client.screen.HealScreenHandler;
import xyz.srgnis.bodyhealthsystem.constants.GUIConstants;
import xyz.srgnis.bodyhealthsystem.network.ClientNetworking;
import xyz.srgnis.bodyhealthsystem.util.Draw;

public class HealScreen
extends class_465<HealScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("bodyhealthsystem", "textures/gui/empty.png");
    BodyPartHealButton headButton;
    BodyPartHealButton leftArmButton;
    BodyPartHealButton rightArmButton;
    BodyPartHealButton torsoButton;
    BodyPartHealButton leftLegButton;
    BodyPartHealButton rightLegButton;
    BodyPartHealButton leftFootButton;
    BodyPartHealButton rightFootButton;

    public HealScreen(class_1703 handler, class_1661 inventory, class_2561 title) {
        super((class_1703)((HealScreenHandler)handler), inventory, title);
        Body body = ((HealScreenHandler)handler).getBody();
        this.headButton = new BodyPartHealButton(body.getPart(PlayerBodyParts.HEAD), 0, 0, GUIConstants.SCALED_HEAD_WIDTH, GUIConstants.SCALED_HEAD_HEIGHT);
        this.leftArmButton = new BodyPartHealButton(body.getPart(PlayerBodyParts.LEFT_ARM), 0, 0, GUIConstants.SCALED_LEFT_ARM_WIDTH, GUIConstants.SCALED_LEFT_ARM_HEIGHT);
        this.rightArmButton = new BodyPartHealButton(body.getPart(PlayerBodyParts.RIGHT_ARM), 0, 0, GUIConstants.SCALED_RIGHT_ARM_WIDTH, GUIConstants.SCALED_RIGHT_ARM_HEIGHT);
        this.torsoButton = new BodyPartHealButton(body.getPart(PlayerBodyParts.TORSO), 0, 0, GUIConstants.SCALED_TORSO_WIDTH, GUIConstants.SCALED_TORSO_HEIGHT);
        this.leftLegButton = new BodyPartHealButton(body.getPart(PlayerBodyParts.LEFT_LEG), 0, 0, GUIConstants.SCALED_LEFT_LEG_WIDTH, GUIConstants.SCALED_LEFT_LEG_HEIGHT);
        this.rightLegButton = new BodyPartHealButton(body.getPart(PlayerBodyParts.RIGHT_LEG), 0, 0, GUIConstants.SCALED_RIGHT_LEG_WIDTH, GUIConstants.SCALED_RIGHT_LEG_HEIGHT);
        this.leftFootButton = new BodyPartHealButton(body.getPart(PlayerBodyParts.LEFT_FOOT), 0, 0, GUIConstants.SCALED_LEFT_FOOT_WIDTH, GUIConstants.SCALED_LEFT_FOOT_HEIGHT);
        this.rightFootButton = new BodyPartHealButton(body.getPart(PlayerBodyParts.RIGHT_FOOT), 0, 0, GUIConstants.SCALED_RIGHT_FOOT_WIDTH, GUIConstants.SCALED_RIGHT_FOOT_HEIGHT);
    }

    protected void method_2389(class_332 drawContext, float delta, int mouseX, int mouseY) {
        int startX = (this.field_22789 - this.field_2792) / 2;
        int startY = (this.field_22790 - this.field_2779) / 2;
        drawContext.method_25302(TEXTURE, startX, startY, 0, 0, this.field_2792, this.field_2779);
    }

    protected void drawButtons(class_332 drawContext, float delta, int mouseX, int mouseY) {
        int startX = (this.field_22789 - this.field_2792) / 2;
        startX = (this.field_2792 - GUIConstants.SCALED_BODY_WIDTH) / 2 + startX;
        int startY = (this.field_22790 - this.field_2779) / 2;
        this.headButton.method_46421(startX + GUIConstants.SCALED_HEAD_X_OFFSET);
        this.headButton.method_46419((startY += (this.field_2779 - GUIConstants.SCALED_BODY_HEIGHT) / 2) + GUIConstants.SCALED_HEAD_Y_OFFSET);
        this.headButton.checkAndSetActive();
        this.method_37063((class_364)this.headButton);
        this.leftArmButton.method_46421(startX + GUIConstants.SCALED_LEFT_ARM_X_OFFSET);
        this.leftArmButton.method_46419(startY + GUIConstants.SCALED_LEFT_ARM_Y_OFFSET);
        this.leftArmButton.checkAndSetActive();
        this.method_37063((class_364)this.leftArmButton);
        this.rightArmButton.method_46421(startX + GUIConstants.SCALED_RIGHT_ARM_X_OFFSET);
        this.rightArmButton.method_46419(startY + GUIConstants.SCALED_RIGHT_ARM_Y_OFFSET);
        this.rightArmButton.checkAndSetActive();
        this.method_37063((class_364)this.rightArmButton);
        this.torsoButton.method_46421(startX + GUIConstants.SCALED_TORSO_X_OFFSET);
        this.torsoButton.method_46419(startY + GUIConstants.SCALED_TORSO_Y_OFFSET);
        this.torsoButton.checkAndSetActive();
        this.method_37063((class_364)this.torsoButton);
        this.leftLegButton.method_46421(startX + GUIConstants.SCALED_LEFT_LEG_X_OFFSET);
        this.leftLegButton.method_46419(startY + GUIConstants.SCALED_LEFT_LEG_Y_OFFSET);
        this.leftLegButton.checkAndSetActive();
        this.method_37063((class_364)this.leftLegButton);
        this.rightLegButton.method_46421(startX + GUIConstants.SCALED_RIGHT_LEG_X_OFFSET);
        this.rightLegButton.method_46419(startY + GUIConstants.SCALED_RIGHT_LEG_Y_OFFSET);
        this.rightLegButton.checkAndSetActive();
        this.method_37063((class_364)this.rightLegButton);
        this.leftFootButton.method_46421(startX + GUIConstants.SCALED_LEFT_FOOT_X_OFFSET);
        this.leftFootButton.method_46419(startY + GUIConstants.SCALED_LEFT_FOOT_Y_OFFSET);
        this.leftFootButton.checkAndSetActive();
        this.method_37063((class_364)this.leftFootButton);
        this.rightFootButton.method_46421(startX + GUIConstants.SCALED_RIGHT_FOOT_X_OFFSET);
        this.rightFootButton.method_46419(startY + GUIConstants.SCALED_RIGHT_FOOT_Y_OFFSET);
        this.rightFootButton.checkAndSetActive();
        this.method_37063((class_364)this.rightFootButton);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.method_2389(drawContext, delta, mouseX, mouseY);
        super.method_25394(drawContext, mouseX, mouseY, delta);
        this.drawButtons(drawContext, delta, mouseX, mouseY);
    }

    protected void method_2388(class_332 drawContext, int mouseX, int mouseY) {
        drawContext.method_51439(this.field_22793, ((HealScreenHandler)this.field_2797).getEntity().method_5477(), this.field_25267, this.field_25268, 0x404040, false);
    }

    class BodyPartHealButton
    extends class_4185 {
        public BodyPart part;

        public BodyPartHealButton(BodyPart part, int x, int y, int width, int height, class_2561 message) {
            super(x, y, width, height, message, button -> {
                ClientNetworking.useHealingItem((class_1297)((HealScreenHandler)HealScreen.this.field_2797).getEntity(), part.getIdentifier(), ((HealScreenHandler)HealScreen.this.field_2797).getItemStack());
                HealScreen.this.method_25419();
            }, class_4185.field_40754);
            this.part = part;
        }

        public BodyPartHealButton(BodyPart part, int x, int y, int width, int height, class_2561 message, class_4185.class_4241 pressAction) {
            super(x, y, width, height, message, pressAction, class_4185.field_40754);
            this.part = part;
        }

        public BodyPartHealButton(BodyPart part, int x, int y, int width, int height) {
            this(part, x, y, width, height, (class_2561)class_2561.method_43470((String)""));
        }

        public void checkAndSetActive() {
            this.field_22763 = this.part.isDamaged();
        }

        public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
            int color = Draw.selectHealthColor(this.part);
            Draw.drawHealthRectangle(drawContext, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, color);
        }
    }
}

