/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.mixin;

import gavinx.temperatureapi.BodyTemperatureState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.BodyProvider;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBody;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.network.ServerNetworking;
import xyz.srgnis.bodyhealthsystem.registry.ModStatusEffects;

@Mixin(value={class_1657.class})
public class PlayerTickMixin {
    @Unique
    private int bhs$heatTickCounter = 0;
    @Unique
    private int bhs$coldTickCounter = 0;

    @Unique
    private static void clearHeatConditions(class_1657 p) {
        p.method_6016(ModStatusEffects.HEAT_STROKE_INIT);
        p.method_6016(ModStatusEffects.HEAT_STROKE_MOD);
        p.method_6016(ModStatusEffects.HEAT_STROKE_SERV);
    }

    @Unique
    private static void clearColdConditions(class_1657 p) {
        p.method_6016(ModStatusEffects.HYPO_MILD);
        p.method_6016(ModStatusEffects.HYPO_MOD);
        p.method_6016(ModStatusEffects.HYPO_SERV);
    }

    @Unique
    private static void setHeatConditionStage(class_1657 p, int stage) {
        PlayerTickMixin.clearHeatConditions(p);
        switch (stage) {
            case 1: {
                p.method_6092(new class_1293(ModStatusEffects.HEAT_STROKE_INIT, 40, 0, false, true, true));
                break;
            }
            case 2: {
                p.method_6092(new class_1293(ModStatusEffects.HEAT_STROKE_MOD, 40, 0, false, true, true));
                break;
            }
            case 3: {
                p.method_6092(new class_1293(ModStatusEffects.HEAT_STROKE_SERV, 40, 0, false, true, true));
            }
        }
    }

    @Unique
    private static void setColdConditionStage(class_1657 p, int stage) {
        PlayerTickMixin.clearColdConditions(p);
        switch (stage) {
            case 1: {
                p.method_6092(new class_1293(ModStatusEffects.HYPO_MILD, 40, 0, false, true, true));
                break;
            }
            case 2: {
                p.method_6092(new class_1293(ModStatusEffects.HYPO_MOD, 40, 0, false, true, true));
                break;
            }
            case 3: {
                p.method_6092(new class_1293(ModStatusEffects.HYPO_SERV, 40, 0, false, true, true));
            }
        }
    }

    @Unique
    private static List<BodyPart> pickColdTargets(Body body) {
        ArrayList<BodyPart> out = new ArrayList<BodyPart>();
        BodyPart la = body.getPart(PlayerBodyParts.LEFT_ARM);
        BodyPart ra = body.getPart(PlayerBodyParts.RIGHT_ARM);
        BodyPart ll = body.getPart(PlayerBodyParts.LEFT_LEG);
        BodyPart rl = body.getPart(PlayerBodyParts.RIGHT_LEG);
        BodyPart lf = body.getPart(PlayerBodyParts.LEFT_FOOT);
        BodyPart rf = body.getPart(PlayerBodyParts.RIGHT_FOOT);
        if (la != null && la.getHealth() > 0.0f) {
            out.add(la);
        }
        if (ra != null && ra.getHealth() > 0.0f) {
            out.add(ra);
        }
        if (ll != null && ll.getHealth() > 0.0f) {
            out.add(ll);
        }
        if (rl != null && rl.getHealth() > 0.0f) {
            out.add(rl);
        }
        if (lf != null && lf.getHealth() > 0.0f) {
            out.add(lf);
        }
        if (rf != null && rf.getHealth() > 0.0f) {
            out.add(rf);
        }
        return out;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        Body body = ((BodyProvider)player).getBody();
        if (!player.method_37908().field_9236) {
            if (body.isPendingDeath()) {
                if (player.method_5805()) {
                    player.method_5643(player.method_48923().method_48829(), 1000.0f);
                }
                return;
            }
            BodyPart head = body.getPart(PlayerBodyParts.HEAD);
            if (player.method_5805() && player.method_6032() <= 0.0f && head != null && head.getHealth() > 0.0f && !body.isDowned()) {
                body.startDowned();
                player.method_6033(1.0f);
                ServerNetworking.broadcastBody((class_1297)player);
            }
            body.tickDowned();
            if (body.isDowned() && player.field_6012 % 20 == 0) {
                ServerNetworking.broadcastBody((class_1297)player);
            }
            if (Config.enableTemperatureSystem && player instanceof class_3222) {
                class_3222 spe = (class_3222)player;
                double tempC = 0.0;
                try {
                    tempC = BodyTemperatureState.getC((class_3222)spe);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (tempC >= 44.0) {
                    player.method_5643(player.method_48923().method_48829(), 1000.0f);
                    return;
                }
            }
        }
        if (body.isDowned()) {
            player.method_5728(false);
            player.method_6016(class_1294.field_5909);
            player.method_6016(class_1294.field_5901);
            player.method_6016(class_1294.field_5911);
            player.method_6092(new class_1293(class_1294.field_5909, 40, 255, false, false));
            player.method_6092(new class_1293(class_1294.field_5901, 40, 255, false, false));
            player.method_6092(new class_1293(class_1294.field_5911, 40, 2, false, false));
            if (!player.method_37908().field_9236) {
                if (!(player.method_5799() || player.method_18376() == class_4050.field_18079 && player.method_5681())) {
                    player.method_5796(true);
                    player.method_18380(class_4050.field_18079);
                }
                player.method_18800(0.0, 0.0, 0.0);
                player.field_6007 = true;
                player.method_5660(false);
            } else if (!(player.method_5799() || player.field_6012 % 6 != 0 || player.method_18376() == class_4050.field_18079 && player.method_5681())) {
                player.method_5796(true);
                player.method_18380(class_4050.field_18079);
            }
            return;
        }
        body.applyBrokenBonesEffects();
        boolean crawlingRequired = false;
        if (body instanceof PlayerBody) {
            PlayerBody pb = (PlayerBody)body;
            crawlingRequired = pb.isCrawlingRequired();
        } else {
            BodyPart leftLeg = body.getPart(PlayerBodyParts.LEFT_LEG);
            BodyPart rightLeg = body.getPart(PlayerBodyParts.RIGHT_LEG);
            BodyPart leftFoot = body.getPart(PlayerBodyParts.LEFT_FOOT);
            Iterator<BodyPart> rightFoot = body.getPart(PlayerBodyParts.RIGHT_FOOT);
            boolean bothLegsBroken = leftLeg != null && rightLeg != null && leftLeg.isBroken() && rightLeg.isBroken();
            boolean bothFeetBroken = leftFoot != null && rightFoot != null && leftFoot.isBroken() && ((BodyPart)((Object)rightFoot)).isBroken();
            boolean bl = crawlingRequired = bothLegsBroken && bothFeetBroken;
        }
        if (crawlingRequired) {
            boolean hasSuppression;
            if (!player.method_37908().field_9236) {
                if (!(player.method_5799() || player.method_18376() == class_4050.field_18079 && player.method_5681())) {
                    player.method_5796(true);
                    player.method_18380(class_4050.field_18079);
                }
            } else if (!(player.method_5799() || player.field_6012 % 8 != 0 || player.method_18376() == class_4050.field_18079 && player.method_5681())) {
                player.method_5796(true);
                player.method_18380(class_4050.field_18079);
            }
            boolean bl = hasSuppression = player.method_6112(ModStatusEffects.MORPHINE_EFFECT) != null || player.method_6112(ModStatusEffects.ADRENALINE_EFFECT) != null;
            if (!hasSuppression) {
                player.method_6016(class_1294.field_5909);
                class_1293 s = player.method_6112(class_1294.field_5909);
                if (s == null || s.method_5578() > 1 || s.method_5584() <= 5) {
                    player.method_6092(new class_1293(class_1294.field_5909, 40, 1, false, false));
                }
            } else {
                player.method_6016(class_1294.field_5909);
            }
        } else if (!player.method_37908().field_9236) {
            if (player.method_18376() == class_4050.field_18079 && !player.method_5799()) {
                player.method_5796(false);
                player.method_18380(class_4050.field_18076);
            }
        } else if (player.method_18376() == class_4050.field_18079 && !player.method_5799() && player.field_6012 % 10 == 0) {
            player.method_5796(false);
            player.method_18380(class_4050.field_18076);
        }
        if (!player.method_37908().field_9236 && Config.enableTemperatureSystem && player instanceof class_3222) {
            class_3222 spe = (class_3222)player;
            double tempC = 0.0;
            try {
                tempC = BodyTemperatureState.getC((class_3222)spe);
            }
            catch (Throwable leftFoot) {
                // empty catch block
            }
            if (tempC >= 40.0) {
                player.method_6092(new class_1293(class_1294.field_5911, 40, 0, false, false, false));
                player.method_6092(new class_1293(class_1294.field_5909, 40, 0, false, false, false));
                if (tempC < 41.0) {
                    PlayerTickMixin.setHeatConditionStage(player, 1);
                }
            }
            if (tempC >= 41.0) {
                player.method_6092(new class_1293(class_1294.field_5911, 40, 1, false, false, false));
                if (tempC < 42.0) {
                    PlayerTickMixin.setHeatConditionStage(player, 2);
                }
            }
            if (tempC >= 42.0) {
                PlayerTickMixin.setHeatConditionStage(player, 3);
                ++this.bhs$heatTickCounter;
                if (this.bhs$heatTickCounter >= 40) {
                    this.bhs$heatTickCounter = 0;
                    ArrayList<BodyPart> candidates = new ArrayList<BodyPart>();
                    for (BodyPart p : body.getNoCriticalParts()) {
                        if (!(p.getHealth() > 0.0f) || p.getIdentifier().equals((Object)PlayerBodyParts.HEAD)) continue;
                        candidates.add(p);
                    }
                    if (candidates.isEmpty()) {
                        for (BodyPart p : body.getParts()) {
                            if (!(p.getHealth() > 0.0f) || p.getIdentifier().equals((Object)PlayerBodyParts.HEAD)) continue;
                            candidates.add(p);
                        }
                    }
                    if (!candidates.isEmpty()) {
                        BodyPart target = (BodyPart)candidates.get(player.method_6051().method_43048(candidates.size()));
                        body.applyNonBreakingDamage(1.0f, player.method_48923().method_48830(), target);
                        body.updateHealth();
                        ServerNetworking.broadcastBody((class_1297)player);
                    }
                }
            } else if (this.bhs$heatTickCounter > 40) {
                this.bhs$heatTickCounter = 40;
            }
            if (tempC < 35.0) {
                if (tempC >= 32.0) {
                    PlayerTickMixin.setColdConditionStage(player, 1);
                } else if (tempC >= 28.0) {
                    player.method_6092(new class_1293(class_1294.field_5909, 40, 1, false, false, false));
                    player.method_6092(new class_1293(class_1294.field_5911, 40, 0, false, false, false));
                    player.method_6092(new class_1293(class_1294.field_5901, 40, 0, false, false, false));
                    PlayerTickMixin.setColdConditionStage(player, 2);
                    ++this.bhs$coldTickCounter;
                    if (this.bhs$coldTickCounter >= 1200) {
                        this.bhs$coldTickCounter = 0;
                        targets = PlayerTickMixin.pickColdTargets(body);
                        if (!targets.isEmpty()) {
                            t = targets.get(player.method_6051().method_43048(targets.size()));
                            body.applyNonBreakingDamage(1.0f, player.method_48923().method_48830(), t);
                            body.updateHealth();
                            ServerNetworking.broadcastBody((class_1297)player);
                        }
                    }
                } else {
                    player.method_6092(new class_1293(class_1294.field_5911, 40, 1, false, false, false));
                    player.method_6092(new class_1293(class_1294.field_5901, 40, 1, false, false, false));
                    player.method_6092(new class_1293(class_1294.field_5909, 40, 2, false, false, false));
                    PlayerTickMixin.setColdConditionStage(player, 3);
                    ++this.bhs$coldTickCounter;
                    if (this.bhs$coldTickCounter >= 300) {
                        this.bhs$coldTickCounter = 0;
                        targets = PlayerTickMixin.pickColdTargets(body);
                        if (!targets.isEmpty()) {
                            t = targets.get(player.method_6051().method_43048(targets.size()));
                            body.applyNonBreakingDamage(1.0f, player.method_48923().method_48830(), t);
                            body.updateHealth();
                            ServerNetworking.broadcastBody((class_1297)player);
                        }
                    }
                }
            } else {
                if (this.bhs$coldTickCounter > 0) {
                    --this.bhs$coldTickCounter;
                }
                PlayerTickMixin.clearColdConditions(player);
            }
        } else if (!player.method_37908().field_9236 && !Config.enableTemperatureSystem) {
            PlayerTickMixin.clearHeatConditions(player);
            PlayerTickMixin.clearColdConditions(player);
            this.bhs$heatTickCounter = 0;
            this.bhs$coldTickCounter = 0;
        }
    }
}

