/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.body;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import net.minecraft.class_8111;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.mixin.ModifyAppliedDamageInvoker;
import xyz.srgnis.bodyhealthsystem.util.Utils;

public abstract class Body {
    protected final HashMap<class_2960, BodyPart> parts = new HashMap();
    protected HashMap<class_2960, BodyPart> noCriticalParts = new HashMap();
    protected class_1309 entity;

    public abstract void initParts();

    public void addPart(class_2960 identifier, BodyPart part) {
        this.parts.put(identifier, part);
    }

    public BodyPart getPart(class_2960 identifier) {
        return this.parts.get(identifier);
    }

    public void removePart(class_2960 identifier) {
        this.parts.remove(identifier);
    }

    public ArrayList<BodyPart> getParts() {
        return new ArrayList<BodyPart>(this.parts.values());
    }

    public ArrayList<class_2960> getPartsIdentifiers() {
        return new ArrayList<class_2960>(this.parts.keySet());
    }

    public ArrayList<BodyPart> getNoCriticalParts() {
        return new ArrayList<BodyPart>(this.noCriticalParts.values());
    }

    public ArrayList<class_2960> getNoCriticalIdentifiers() {
        return new ArrayList<class_2960>(this.noCriticalParts.keySet());
    }

    public void writeToNbt(class_2487 nbt) {
        class_2487 new_nbt = new class_2487();
        for (BodyPart part : this.getParts()) {
            part.writeToNbt(new_nbt);
        }
        nbt.method_10566("bodyhealthsystem", (class_2520)new_nbt);
    }

    public void readFromNbt(class_2487 nbt) {
        class_2487 bodyNbt = nbt.method_10562("bodyhealthsystem");
        if (!bodyNbt.method_33133()) {
            this.noCriticalParts.clear();
            for (class_2960 partId : this.getPartsIdentifiers()) {
                if (bodyNbt.method_10562(partId.toString()).method_33133()) continue;
                BodyPart part = this.getPart(partId);
                part.readFromNbt(bodyNbt.method_10562(partId.toString()));
                if (!(part.getHealth() > 0.0f)) continue;
                this.noCriticalParts.put(part.getIdentifier(), part);
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Body of " + this.entity.method_5477().getString() + "\n");
        for (BodyPart p : this.getParts()) {
            s.append(p.toString());
        }
        return s.toString();
    }

    public void healAll() {
        for (BodyPart part : this.getParts()) {
            part.heal();
        }
    }

    public void heal(float amount) {
        if (amount > 0.0f) {
            ArrayList<BodyPart> parts_l = this.getParts();
            Collections.shuffle(parts_l);
            for (BodyPart part : parts_l) {
                if (amount <= 0.0f) break;
                amount = part.heal(amount);
            }
        }
    }

    public void healPart(int amount, class_2960 partID) {
        this.healPart((float)amount, this.getPart(partID));
    }

    public void healPart(float amount, BodyPart part) {
        part.heal(amount);
    }

    public void applyDamageBySource(float amount, class_1282 source) {
        this.applyDamageLocalRandom(amount, source);
    }

    public void applyDamageLocal(float amount, class_1282 source, BodyPart part) {
        this.takeDamage(amount, source, part);
    }

    public void applyDamageLocalRandom(float amount, class_1282 source) {
        this.takeDamage(amount, source, this.getNoCriticalParts().get(this.entity.method_6051().method_43048(this.noCriticalParts.size())));
    }

    public void applyDamageGeneral(float amount, class_1282 source) {
        this.applyDamageList(amount, source, this.getParts());
    }

    public void applyDamageGeneralRandom(float amount, class_1282 source) {
        this.applyDamageListRandom(amount, source, this.getParts());
    }

    public void applyDamageList(float amount, class_1282 source, List<BodyPart> parts) {
        float split_amount = amount / (float)parts.size();
        for (BodyPart bodyPart : parts) {
            this.takeDamage(split_amount, source, bodyPart);
        }
    }

    public void applyDamageListRandom(float amount, class_1282 source, List<BodyPart> parts) {
        List<Float> damages = Utils.n_random(amount, parts.size());
        int i = 0;
        for (BodyPart bodyPart : parts) {
            this.takeDamage(damages.get(i).floatValue(), source, bodyPart);
            ++i;
        }
    }

    public void applyDamageRandomList(float amount, class_1282 source) {
        List<BodyPart> randomlist = Utils.random_sublist(this.getNoCriticalParts(), this.entity.method_6051().method_43048(this.getNoCriticalParts().size() + 1));
        this.applyDamageList(amount, source, randomlist);
    }

    public void applyDamageFullRandom(float amount, class_1282 source) {
        List<BodyPart> randomlist = Utils.random_sublist(this.getNoCriticalParts(), this.entity.method_6051().method_43048(this.getNoCriticalParts().size() + 1));
        this.applyDamageListRandom(amount, source, randomlist);
    }

    public float takeDamage(float amount, class_1282 source, BodyPart part) {
        amount = this.applyArmorToDamage(source, amount, part);
        float f = amount = ((ModifyAppliedDamageInvoker)this.entity).invokeModifyAppliedDamage(source, amount);
        amount = Math.max(amount - this.entity.method_6067(), 0.0f);
        this.entity.method_6073(this.entity.method_6067() - (f - amount));
        float g = f - amount;
        if (g > 0.0f && g < 3.4028235E37f && source.method_5529() instanceof class_3222) {
            ((class_3222)source.method_5529()).method_7339(class_3468.field_15408, Math.round(g * 10.0f));
        }
        if (amount == 0.0f) {
            return amount;
        }
        float h = part.getHealth();
        float remaining = source.method_49708(class_8111.field_42349) && this.entity.method_6112(class_1294.field_5899) != null ? part.damageWithoutKill(amount) : part.damage(amount);
        this.entity.method_6066().method_5547(source, amount);
        this.entity.method_6073(this.entity.method_6067() - amount);
        this.entity.method_32876(class_5712.field_28736);
        return remaining;
    }

    public abstract float applyArmorToDamage(class_1282 var1, float var2, BodyPart var3);

    public abstract void applyCriticalPartsEffect();

    public void applyStatusEffectWithAmplifier(class_1291 effect, int amplifier) {
        if (amplifier >= 0) {
            class_1293 s = this.entity.method_6112(effect);
            if (s == null) {
                this.entity.method_6092(new class_1293(effect, 40, amplifier));
            } else if (s.method_5578() > amplifier || s.method_5584() <= 5 || s.method_5578() != amplifier) {
                this.entity.method_6092(new class_1293(effect, 40, amplifier));
            }
        }
    }

    public int getAmplifier(BodyPart part) {
        if (part.getHealth() <= part.getCriticalThreshold()) {
            return 1;
        }
        return 0;
    }

    public void updateHealth() {
        float max_health = 0.0f;
        float actual_health = 0.0f;
        boolean shouldDie = false;
        for (BodyPart part : this.getParts()) {
            max_health += part.getMaxHealth();
            actual_health += part.getHealth();
            if (!part.isKillRequirement || !(part.getHealth() <= 0.0f)) continue;
            shouldDie = true;
        }
        if (shouldDie) {
            this.entity.method_6033(0.0f);
        } else {
            this.entity.method_6033(this.entity.method_6063() * (actual_health / max_health));
        }
    }

    public boolean shouldDie() {
        for (BodyPart part : this.getParts()) {
            if (!part.isKillRequirement || !(part.getHealth() <= 0.0f)) continue;
            return true;
        }
        return false;
    }

    public void checkNoCritical(BodyPart part) {
        if (part.getHealth() > 0.0f) {
            this.noCriticalParts.putIfAbsent(part.getIdentifier(), part);
        } else {
            this.noCriticalParts.remove(part.getIdentifier());
        }
    }

    public void applyTotem() {
        for (BodyPart part : this.getParts()) {
            if (!(part.getHealth() < 1.0f)) continue;
            part.setHealth(1.0f);
        }
        this.updateHealth();
    }
}

